/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.google.common.collect.Lists;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.spells.shapes.ShapeRaytrace;
import com.ma.tools.SummonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableObject;

public class ShapeChain
extends ShapeRaytrace {
    public ShapeChain(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 5.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.MAGNITUDE, 10.0f, 1.0f, 100.0f, 1.0f, 3.0f), new AttributeValuePair(Attribute.RANGE, 8.0f, 8.0f, 32.0f, 1.0f, 2.0f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        if (!source.isPlayerCaster()) {
            return Arrays.asList(SpellTarget.NONE);
        }
        List<SpellTarget> tgts = super.Target(source, world, modificationData, recipe);
        SpellTarget tgt = tgts.get(0);
        if (tgt == SpellTarget.NONE) {
            return tgts;
        }
        int radius = (int)modificationData.getValue(Attribute.RADIUS);
        int max = (int)modificationData.getValue(Attribute.MAGNITUDE);
        ArrayList<SpellTarget> targetsList = new ArrayList<SpellTarget>();
        targetsList.add(tgt);
        if (tgt.isBlock()) {
            Block search = world.func_180495_p(tgt.getBlock()).func_177230_c();
            ArrayList<Long> blockTargets = new ArrayList<Long>();
            blockTargets.add(tgt.getBlock().func_218275_a());
            this.chainTargetBlocks(world, search, tgt.getBlockFace(null), tgt.getBlock(), radius, max, blockTargets, targetsList);
        } else if (tgt.isEntity()) {
            ArrayList<Integer> entityTargets = new ArrayList<Integer>();
            entityTargets.add(tgt.getEntity().func_145782_y());
            this.chainTargetEntities(world, source.getCaster(), tgt.getEntity(), radius, max, entityTargets, targetsList);
        }
        if (world.field_72995_K) {
            for (int i = 1; i < targetsList.size(); ++i) {
                SpellTarget prev = targetsList.get(i - 1);
                SpellTarget next = targetsList.get(i);
                Vector3d prevPos = prev.isBlock() ? new Vector3d((double)((float)prev.getBlock().func_177958_n() + 0.5f), (double)((float)prev.getBlock().func_177956_o() + 0.5f), (double)((float)prev.getBlock().func_177952_p() + 0.5f)) : prev.getEntity().func_213303_ch();
                Vector3d nextPos = next.isBlock() ? new Vector3d((double)((float)next.getBlock().func_177958_n() + 0.5f), (double)((float)next.getBlock().func_177956_o() + 0.5f), (double)((float)next.getBlock().func_177952_p() + 0.5f)) : prev.getEntity().func_213303_ch();
                world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), prevPos.field_72450_a, prevPos.field_72448_b, prevPos.field_72449_c, nextPos.field_72450_a, nextPos.field_72448_b, nextPos.field_72449_c);
            }
        }
        return targetsList;
    }

    private void chainTargetBlocks(World world, Block searchType, Direction castDir, BlockPos origin, int range, int max, List<Long> searchedPositions, List<SpellTarget> targets) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)origin, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (Direction direction : Direction.values()) {
                BlockPos offset = blockpos.func_177972_a(direction);
                if (searchedPositions.contains(offset.func_218275_a())) continue;
                searchedPositions.add(offset.func_218275_a());
                BlockState blockstate = world.func_180495_p(offset);
                if (blockstate.func_177230_c() == searchType) {
                    targets.add(new SpellTarget(offset, castDir));
                    ++i;
                    if (j < 6) {
                        queue.add(new Tuple((Object)offset, (Object)(j + 1)));
                    }
                }
                if (i >= max - 1) break;
            }
            if (i < max - 1) continue;
            break;
        }
    }

    private void chainTargetEntities(World world, LivingEntity caster, Entity origin, int range, int max, List<Integer> searchedEntities, List<SpellTarget> targets) {
        MutableObject lastEntity = new MutableObject(null);
        world.func_175647_a(MobEntity.class, new AxisAlignedBB(origin.func_233580_cy_()).func_186662_g((double)range), e -> {
            if (SummonUtils.isSummon((LivingEntity)e) && SummonUtils.getSummoner((LivingEntity)e) == caster) {
                return false;
            }
            return e.func_70089_S() && !searchedEntities.contains(e.func_145782_y());
        }).stream().sorted((o1, o2) -> {
            double d2;
            double d1 = o1.func_70068_e(origin);
            return d1 < (d2 = o2.func_70068_e(origin)) ? -1 : (d1 > d2 ? 1 : 0);
        }).forEach(e -> {
            if (targets.size() < max) {
                lastEntity.setValue(e);
                targets.add(new SpellTarget((Entity)e));
                searchedEntities.add(e.func_145782_y());
            }
        });
        if (lastEntity.getValue() != null && searchedEntities.size() < max) {
            this.chainTargetEntities(world, caster, (Entity)lastEntity.getValue(), range, max, searchedEntities, targets);
        }
    }

    @Override
    public float initialComplexity() {
        return 40.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

