/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.tools.BlockUtils;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ComponentGust
extends Component {
    public static final HashMap<Material, Integer> validMaterials = new HashMap();

    public ComponentGust(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 0.0f, 3.0f, 1.0f, 2.0f));
        validMaterials.put(Material.field_215712_y, 1);
        validMaterials.put(Material.field_151585_k, 1);
        validMaterials.put(Material.field_151582_l, 1);
        validMaterials.put(Material.field_151569_G, 1);
        validMaterials.put(Material.field_151581_o, 1);
        validMaterials.put(Material.field_151584_j, 2);
        validMaterials.put(Material.field_151597_y, 2);
        validMaterials.put(Material.field_215713_z, 3);
        validMaterials.put(Material.field_151570_A, 3);
        validMaterials.put(Material.field_151572_C, 3);
        validMaterials.put(Material.field_203243_f, 3);
        validMaterials.put(Material.field_204868_h, 3);
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isBlock()) {
            if (!context.getWorld().func_195588_v(target.getBlock())) {
                return ComponentApplicationResult.FAIL;
            }
            BlockState state = context.getWorld().func_180495_p(target.getBlock());
            Material m = state.func_185904_a();
            float magnitude = modificationData.getValue(Attribute.MAGNITUDE);
            if (validMaterials.containsKey(m) && magnitude >= (float)validMaterials.get(m).intValue() && BlockUtils.destroyBlock(source.getCaster(), (World)context.getWorld(), target.getBlock(), true, 3, ToolType.HOE, ToolType.AXE, ToolType.PICKAXE, ToolType.SHOVEL)) {
                BlockUtils.updateBlockState((World)context.getWorld(), target.getBlock());
                return ComponentApplicationResult.SUCCESS;
            }
        } else if (target.isEntity() && target.getEntity() instanceof ItemEntity) {
            Vector3d tPos = target.getEntity().func_213303_ch();
            Vector3d cPos = source.getOrigin();
            Vector3d delta = cPos.func_178788_d(tPos).func_72432_b();
            target.getEntity().func_213317_d(delta);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WIND;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.AoE.WIND;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age < 10) {
            float particle_spread = 1.0f;
            int particleCount = 5;
            for (int i = 0; i < particleCount; ++i) {
                world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), Math.random() * (double)0.2f, (double)0.3f, 2.5);
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 50;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

