/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.utility.EntityFillHole;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ComponentFillHole
extends Component {
    public ComponentFillHole(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.RADIUS, 3.0f, 1.0f, 7.0f, 1.0f, 1.0f), new AttributeValuePair(Attribute.HEIGHT, 3.0f, 1.0f, 7.0f, 1.0f, 1.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 50;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (source.isPlayerCaster() && target.isBlock()) {
            BlockPos targetPos = target.getBlock().func_177972_a(target.getBlockFace(this));
            PlayerEntity caster = source.getPlayer();
            Block toPlace = null;
            ItemStack offhandItem = caster.func_184586_b(source.getHand() == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND);
            if (!offhandItem.func_190926_b() && offhandItem.func_77973_b() instanceof BlockItem) {
                toPlace = ((BlockItem)offhandItem.func_77973_b()).func_179223_d();
            } else {
                BlockState impactState = context.getWorld().func_180495_p(target.getBlock());
                if (impactState != null && (toPlace = impactState.func_177230_c()).hasTileEntity(impactState)) {
                    return ComponentApplicationResult.FAIL;
                }
            }
            if (toPlace == null) {
                return ComponentApplicationResult.FAIL;
            }
            byte height = (byte)modificationData.getValue(Attribute.HEIGHT);
            byte radius = (byte)modificationData.getValue(Attribute.RADIUS);
            EntityFillHole efh = new EntityFillHole((World)context.getWorld(), toPlace, targetPos, caster, height, radius);
            context.getWorld().func_217376_c((Entity)efh);
            return ComponentApplicationResult.TARGET_ENTITY_SPAWNED;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }
}

