/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.items.ItemInit;
import com.ma.items.artifice.FortuneRing;
import com.ma.items.artifice.SpellModifierRing;
import com.ma.tools.BlockUtils;
import com.ma.tools.EnchantmentUtils;
import com.ma.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ComponentBreak
extends Component {
    private ToolType[] emulatedTools = new ToolType[]{ToolType.AXE, ToolType.PICKAXE, ToolType.SHOVEL, ToolType.get((String)"hammer")};

    public ComponentBreak(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 15.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        ComponentApplicationResult result = ComponentApplicationResult.FAIL;
        if (target.isBlock() && source.isPlayerCaster()) {
            boolean silkTouch = EnchantmentUtils.getSilkTouch(source.getPlayer());
            int fortune_level = 0;
            if (!silkTouch) {
                fortune_level = EnchantmentUtils.getFortuneLevel(source.getPlayer());
            }
            int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
            Pair<Boolean, Boolean> captureRedirect = InventoryUtilities.getCaptureAndRedirect(source.getPlayer());
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (((Boolean)captureRedirect.getFirst()).booleanValue()) {
                drops.addAll(BlockUtils.destroyBlockCaptureDrops(source.getCaster(), (World)context.getWorld(), target.getBlock(), silkTouch, fortune_level, magnitude, this.emulatedTools));
                if (source.isPlayerCaster()) {
                    InventoryUtilities.redirectCaptureOrDrop(source.getPlayer(), (World)context.getWorld(), drops, (Boolean)captureRedirect.getSecond());
                }
                result = ComponentApplicationResult.SUCCESS;
            } else if (BlockUtils.destroyBlock(source.getCaster(), (World)context.getWorld(), target.getBlock(), true, silkTouch, fortune_level, magnitude, this.emulatedTools)) {
                result = ComponentApplicationResult.SUCCESS;
            }
            if (result == ComponentApplicationResult.SUCCESS) {
                if (silkTouch) {
                    ((SpellModifierRing)ItemInit.SILK_TOUCH_RING.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true);
                } else {
                    ((FortuneRing)ItemInit.FORTUNE_RING_GREATER.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true);
                    ((FortuneRing)ItemInit.FORTUNE_RING.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true);
                    ((FortuneRing)ItemInit.FORTUNE_RING_MINOR.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true);
                }
            }
        }
        return result;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.EARTH;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 1) {
            return;
        }
        float particle_spread = 1.0f;
        float v = 0.1f;
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            Vector3d velocity = new Vector3d((double)(-v / 2.0f) + Math.random() * (double)v, Math.random() * (double)v, (double)(-v / 2.0f) + Math.random() * (double)v);
            world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public float initialComplexity() {
        return 1.0f;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

