/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.items.ItemInit;
import com.ma.tools.BlockUtils;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class RitualEffectHole
extends RitualEffect {
    protected static final int radius = 1;

    public RitualEffectHole(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        int delay = 10;
        BlockPos pos = context.getCenter().func_177977_b();
        while (pos.func_177956_o() > 1 && context.getWorld().func_180495_p(pos).func_177230_c() != Blocks.field_150357_h) {
            DelayedEventQueue.pushEvent(context.getWorld(), new TimedDelayedEvent<DelayData>("hole", delay, new DelayData(context.getCaster(), pos, context.getWorld()), this::breakBlocks));
            delay += 10;
            pos = pos.func_177977_b();
        }
        MutableBoolean drop_book = new MutableBoolean(true);
        context.getAllPositions().forEach(c -> {
            if (c.isPresent() && c.getReagent() != null && c.getReagent().getResourceLocation().equals((Object)((Item)ItemInit.FLAT_LANDS_BOOK.get()).getRegistryName()) && c.getReagent().shouldConsumeReagent()) {
                drop_book.setFalse();
            }
        });
        if (drop_book.booleanValue()) {
            EntityPresentItem epi = new EntityPresentItem(context.getWorld(), context.getCenter().func_177958_n(), context.getCenter().func_177956_o() + 1, context.getCenter().func_177952_p());
            epi.func_92058_a(new ItemStack((IItemProvider)ItemInit.FLAT_LANDS_BOOK.get()));
            epi.func_213293_j(0.0, 0.0, 0.0);
            context.getWorld().func_217376_c((Entity)epi);
        }
        return true;
    }

    private void breakBlocks(String identifier, DelayData data) {
        if (data.caster == null || data.world == null || !data.world.func_195588_v(data.center)) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos target = data.center.func_177982_a(i, 0, j);
                if (!data.world.func_195588_v(target) || data.world.func_175625_s(target) != null) continue;
                BlockUtils.destroyBlock((LivingEntity)data.caster, data.world, target, false, 2, ToolType.SHOVEL, ToolType.PICKAXE);
            }
        }
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }

    protected class DelayData {
        public PlayerEntity caster;
        public BlockPos center;
        public World world;

        public DelayData(PlayerEntity caster, BlockPos pos, World world) {
            this.caster = caster;
            this.center = pos;
            this.world = world;
        }
    }
}

