/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.api.sound.SFX;
import com.ma.entities.faction.EntityBroker;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RitualEffectBroker
extends RitualEffect {
    HashMap<BlockPos, Vector3f> effectWindDirections = new HashMap();

    public RitualEffectBroker(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        if (context.getWorld().field_72995_K) {
            return true;
        }
        EntityBroker entity = new EntityBroker(context.getWorld());
        entity.func_70107_b((double)context.getCenter().func_177958_n() + 0.5, context.getCenter().func_177956_o(), (double)context.getCenter().func_177952_p() + 0.5);
        entity.func_213728_s(12000);
        context.getWorld().func_217376_c((Entity)entity);
        context.getWorld().func_184148_a(null, (double)context.getCenter().func_177958_n(), (double)context.getCenter().func_177956_o(), (double)context.getCenter().func_177952_p(), SFX.Event.Ritual.IRON_BELL, SoundCategory.AMBIENT, 1.0f, 1.0f);
        this.effectWindDirections.remove(context.getCenter());
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        Vector3d pos;
        BlockPos block;
        int i;
        Random rand = context.getWorld().field_73012_v;
        Vector3f wind = this.effectWindDirections.getOrDefault(context.getCenter(), new Vector3f(rand.nextFloat() - 0.5f, 0.0f, rand.nextFloat() - 0.5f));
        wind.func_214905_a(Vector3f.field_229181_d_.func_229187_a_((float)(rand.nextInt(4) - 2)));
        for (i = 0; i < 5; ++i) {
            block = context.getCenter().func_177982_a(-3 + rand.nextInt(7), 0, -3 + rand.nextInt(7));
            pos = new Vector3d((double)block.func_177958_n() + rand.nextDouble(), (double)((float)block.func_177956_o() + rand.nextFloat()), (double)block.func_177952_p() + rand.nextDouble());
            context.getWorld().func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), (double)0.04f, (double)0.32f, (double)0.03f);
        }
        for (i = 0; i < 75; ++i) {
            block = context.getCenter().func_177982_a(-3 + rand.nextInt(7), 0, -3 + rand.nextInt(7));
            pos = new Vector3d((double)block.func_177958_n() + rand.nextDouble(), (double)block.func_177956_o(), (double)block.func_177952_p() + rand.nextDouble());
            context.getWorld().func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), (double)(wind.func_195899_a() * 0.25f), (double)(wind.func_195900_b() * 0.25f), (double)(wind.func_195902_c() * 0.25f));
        }
        if (rand.nextFloat() < 0.1f) {
            BlockPos block2 = context.getCenter().func_177982_a(-3 + rand.nextInt(7), 2, -3 + rand.nextInt(7));
            Vector3d pos2 = new Vector3d((double)block2.func_177958_n() + rand.nextDouble(), (double)((float)block2.func_177956_o() + rand.nextFloat() * 2.0f), (double)block2.func_177952_p() + rand.nextDouble());
            for (int i2 = 0; i2 < 50; ++i2) {
                context.getWorld().func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_RANDOM.get())), pos2.func_82615_a(), pos2.func_82617_b(), pos2.func_82616_c(), (double)0.05f, (double)0.05f, (double)0.05f);
            }
        }
        this.effectWindDirections.put(context.getCenter(), wind);
        return true;
    }
}

