/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.api.sound.SFX;
import com.ma.api.spells.SpellCraftingContext;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.config.GeneralModConfig;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.events.EventDispatcher;
import com.ma.items.ItemInit;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RitualEffectArcana
extends RitualEffect {
    public RitualEffectArcana(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Nullable
    private SpellRecipe getRecipe(IRitualContext context) {
        ItemStack recipeItem = ItemStack.field_190927_a;
        for (ItemStack stack : context.getCollectedReagents()) {
            if (!SpellRecipe.isReagentContainer(stack)) continue;
            recipeItem = stack;
            break;
        }
        if (recipeItem == null) {
            return null;
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(recipeItem.func_196082_o());
        if (recipe.isValid()) {
            return recipe;
        }
        return null;
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        SpellRecipe recipe = this.getRecipe(context);
        if (recipe == null || context.getCaster() == null) {
            return null;
        }
        SpellCraftingContext spc = new SpellCraftingContext(context.getCaster());
        if (((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).isCraftable(spc) && recipe.getModifiers().stream().allMatch(m -> m.isCraftable(spc)) && recipe.getComponents().stream().allMatch(c -> ((Component)c.getPart()).isCraftable(spc))) {
            return null;
        }
        return new TranslationTextComponent("mana-and-artifice:rituals/arcana.start_failed");
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        SpellRecipe recipe = this.getRecipe(context);
        if (recipe == null) {
            return false;
        }
        ItemStack spell = new ItemStack((IItemProvider)ItemInit.SPELL.get());
        recipe.setMysterious(false);
        recipe.writeToNBT(spell.func_196082_o());
        context.getWorld().func_184148_a(null, (double)context.getCenter().func_177958_n(), (double)context.getCenter().func_177956_o(), (double)context.getCenter().func_177952_p(), SFX.Event.Player.SPELL_CREATED, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityPresentItem item = new EntityPresentItem(context.getWorld(), (float)context.getCenter().func_177984_a().func_177958_n() + 0.5f, context.getCenter().func_177984_a().func_177956_o(), (float)context.getCenter().func_177984_a().func_177952_p() + 0.5f, spell);
        context.getWorld().func_217376_c((Entity)item);
        if (recipe.isValid()) {
            EventDispatcher.DispatchSpellCrafted(recipe, context.getCaster());
        }
        if (((Boolean)GeneralModConfig.LITE_MODE.get()).booleanValue()) {
            context.getCaster().getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
                if (recipe.getShape() != null) {
                    r.addRoteXP((ISpellComponent)((ModifiedSpellPart)recipe.getShape()).getPart(), ((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).requiredXPForRote());
                }
                recipe.iterateComponents(comp -> {
                    if (comp != null) {
                        r.addRoteXP((ISpellComponent)comp.getPart(), ((Component)comp.getPart()).requiredXPForRote());
                    }
                });
                recipe.getModifiers().forEach(m -> r.addRoteXP((ISpellComponent)m, m.requiredXPForRote()));
            });
        }
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }

    @Override
    protected boolean modifyRitualReagentsAndPatterns(ItemStack dataStack, IRitualContext context) {
        if (!SpellRecipe.isReagentContainer(dataStack)) {
            return false;
        }
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-shape"), SpellRecipe.getShapeReagents(dataStack));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-component"), SpellRecipe.getComponentReagents(dataStack));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-modifier-1"), SpellRecipe.getModifierReagents(dataStack, 0));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-modifier-2"), SpellRecipe.getModifierReagents(dataStack, 1));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-modifier-3"), SpellRecipe.getModifierReagents(dataStack, 2));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-complexity"), SpellRecipe.getComplexityReagents(dataStack));
        context.replacePatterns(SpellRecipe.getPatterns(dataStack));
        return true;
    }
}

