/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.runeforging;

import com.google.gson.JsonObject;
import com.ma.api.recipes.IRunescribeRecipe;
import com.ma.items.ItemInit;
import com.ma.items.runes.ItemRunePattern;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class RunescribingRecipe
extends AMRecipeBase
implements IRunescribeRecipe {
    private long hMutex;
    private long vMutex;
    private ResourceLocation patternItem = new ResourceLocation("");
    private Item __outputItem = null;

    public RunescribingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        this.hMutex = recipeJSON.get("mutex_h").getAsLong();
        this.vMutex = recipeJSON.get("mutex_v").getAsLong();
        this.patternItem = new ResourceLocation(recipeJSON.get("output").getAsString());
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack checkStack = inv.func_70301_a(0);
        if (inv.func_70302_i_() == 1 && checkStack.func_77973_b() == ItemInit.RUNE_PATTERN.get()) {
            return ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).getHMutex(checkStack) == this.hMutex && ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).getVMutex(checkStack) == this.vMutex;
        }
        return false;
    }

    public ItemStack assemble(CraftingInventory inv) {
        return this.func_77571_b();
    }

    public ItemStack func_77571_b() {
        IForgeRegistry itemRegistry;
        if (this.__outputItem == null && (itemRegistry = GameRegistry.findRegistry(Item.class)) != null) {
            this.__outputItem = (Item)itemRegistry.getValue(this.patternItem);
        }
        if (this.__outputItem != null) {
            return new ItemStack((IItemProvider)this.__outputItem);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.RUNESCRIBING_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeInit.RUNESCRIBING_TYPE;
    }

    @Override
    public long getHMutex() {
        return this.hMutex;
    }

    public void setHMutex(long mutex) {
        this.hMutex = mutex;
    }

    @Override
    public long getVMutex() {
        return this.vMutex;
    }

    public void setVMutex(long mutex) {
        this.vMutex = mutex;
    }

    public ResourceLocation getOutputResource() {
        return this.patternItem;
    }

    public void setOutputResource(String output) {
        this.patternItem = new ResourceLocation(output);
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.func_77571_b();
    }
}

