/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.multiblock;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.multiblock.MultiblockDefinition;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class MultiblockRecipeSerializer
extends AMRecipeBaseSerializer<MultiblockDefinition> {
    public MultiblockRecipeSerializer(Function<ResourceLocation, MultiblockDefinition> patternMap) {
        super(patternMap);
    }

    @Override
    protected MultiblockDefinition readExtra(ResourceLocation recipeId, JsonObject json) {
        MultiblockDefinition recipe = new MultiblockDefinition(recipeId);
        recipe.parseJSON(json);
        return recipe;
    }

    @Override
    protected MultiblockDefinition readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            MultiblockDefinition recipe = new MultiblockDefinition(recipeId);
            recipe.setStructurePath(buffer.func_192575_l());
            int count = buffer.readInt();
            HashMap<ResourceLocation, Integer> matchersByBlock = new HashMap<ResourceLocation, Integer>();
            for (int i = 0; i < count; ++i) {
                ResourceLocation rLoc = buffer.func_192575_l();
                int index = buffer.readInt();
                matchersByBlock.put(rLoc, index);
            }
            recipe.setSpecialBlockMatchersByBlock(matchersByBlock);
            count = buffer.readInt();
            HashMap<Long, Integer> matchersByOffset = new HashMap<Long, Integer>();
            for (int i = 0; i < count; ++i) {
                Long offset = buffer.readLong();
                int index = buffer.readInt();
                matchersByOffset.put(offset, index);
            }
            recipe.setSpecialBlockMatchersByOffset(matchersByOffset);
            recipe.deserializeVariations(buffer.func_150793_b());
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading multiblock definition from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void writeExtra(PacketBuffer buffer, MultiblockDefinition recipe) {
        try {
            buffer.func_192572_a(recipe.getStructurePath());
            HashMap<ResourceLocation, Integer> matchersByBlock = recipe.getSpecialBlockMatchersByBlock();
            buffer.writeInt(matchersByBlock.size());
            matchersByBlock.entrySet().forEach(e -> {
                buffer.func_192572_a((ResourceLocation)e.getKey());
                buffer.writeInt(((Integer)e.getValue()).intValue());
            });
            HashMap<Long, Integer> matchersByOffset = recipe.getSpecialBlockMatchersByOffset();
            buffer.writeInt(matchersByOffset.size());
            matchersByOffset.entrySet().forEach(e -> {
                buffer.writeLong(((Long)e.getKey()).longValue());
                buffer.writeInt(((Integer)e.getValue()).intValue());
            });
            buffer.func_150786_a(recipe.serializeVariations());
        }
        catch (Exception e2) {
            ManaAndArtifice.LOGGER.error("Error writing multiblock definition to packet.", (Throwable)e2);
            throw e2;
        }
    }
}

