/*
 * Decompiled with CFR 0.152.
 */
package com.ma.progression;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.events.BonefeatherCharmUsedEvent;
import com.ma.api.events.CantripCastEvent;
import com.ma.api.events.ConstructCraftedEvent;
import com.ma.api.events.EnderfeatherCharmUsedEvent;
import com.ma.api.events.ManaweaveCraftingEvent;
import com.ma.api.events.ManaweavePatternDrawnEvent;
import com.ma.api.events.PlayerMagicLevelUpEvent;
import com.ma.api.events.RitualCompleteEvent;
import com.ma.api.events.RuneforgeCraftingEvent;
import com.ma.api.events.RuneforgeEnchantEvent;
import com.ma.api.events.RunescribeCraftingEvent;
import com.ma.api.events.SpellCastEvent;
import com.ma.api.events.SpellCraftedEvent;
import com.ma.api.progression.ProgressionCondition;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.progression.ProgressionHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProgressionEventHandler {
    private static <T extends Event> void tickConditionsOfType(PlayerEntity player, T event, ProgressionCondition.EventType<T> type) {
        if (player == null) {
            return;
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null || progression.getTier() >= 5) {
            return;
        }
        List conditions = ProgressionHelper.getConditionsForTierExcluding(progression.getTier(), type, progression.getCompletedProgressionSteps()).stream().filter(e -> e.getClassType() == event.getClass()).collect(Collectors.toList());
        boolean advanced = false;
        for (ProgressionCondition condition : conditions) {
            if (!condition.getClassType().equals(event.getClass()) || !condition.isMet(event)) continue;
            advanced = true;
            progression.addTierProgressionComplete(condition.getRegistryName());
        }
        if (advanced && progression.getTierProgress() >= 1.0f) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.ready"), Util.field_240973_b_);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.player, event, ProgressionCondition.EventType.TICK);
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        IPlayerProgression progression = (IPlayerProgression)event.getPlayer().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression != null && progression.getTier() == 1 && progression.getTierProgress() >= 1.0f) {
            progression.setTier(progression.getTier() + 1, event.getPlayer());
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.advanced", new Object[]{progression.getTier()}), Util.field_240973_b_);
        }
    }

    @SubscribeEvent
    public static void onRitualCompleted(RitualCompleteEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCaster(), event, ProgressionCondition.EventType.RITUAL);
    }

    @SubscribeEvent
    public static void onManaweaveCrafted(ManaweaveCraftingEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.MANAWEAVE_CRAFT);
    }

    @SubscribeEvent
    public static void onManaweavePatternDrawn(ManaweavePatternDrawnEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.MANAWEAVE_PATTERN_DRAWN);
    }

    @SubscribeEvent
    public static void onRuneforgeCraft(RuneforgeCraftingEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.RUNEFORGE_CRAFT);
    }

    @SubscribeEvent
    public static void onRuneforgeEnchant(RuneforgeEnchantEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.RUNEFORGE_ENCHANT);
    }

    @SubscribeEvent
    public static void onRunescribeCraft(RunescribeCraftingEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.RUNESCRIBE);
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.CRAFT);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.DIMENSION_CHANGE);
    }

    @SubscribeEvent
    public static void onPlayerMagicLevelUp(PlayerMagicLevelUpEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.MAGIC_LEVEL_UP);
    }

    @SubscribeEvent
    public static void onSpellCrafted(SpellCraftedEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.SPELL_CRAFTED);
    }

    @SubscribeEvent
    public static void onSpellCast(SpellCastEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCaster(), event, ProgressionCondition.EventType.SPELL_CAST);
    }

    @SubscribeEvent
    public static void onPlayerAdvancement(AdvancementEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.ADVANCEMENT);
        if (event.getPlayer().field_70170_p.field_72995_K) {
            ProgressionEventHandler.confirmExistingAdvancements(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onCantripCast(CantripCastEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.CANTRIP_CAST);
    }

    @SubscribeEvent
    public static void onConstructCrafted(ConstructCraftedEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getCrafter(), event, ProgressionCondition.EventType.CONSTRUCT_CRAFT);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ProgressionEventHandler.confirmExistingAdvancements(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.RIGHT_CLICK_BLOCK);
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickItem event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.RIGHT_CLICK_ITEM);
    }

    @SubscribeEvent
    public static void onBonefeatherCharmUsed(BonefeatherCharmUsedEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.BONEFEATHER_USE);
    }

    @SubscribeEvent
    public static void onEnderfeatherCharmUsed(EnderfeatherCharmUsedEvent event) {
        ProgressionEventHandler.tickConditionsOfType(event.getPlayer(), event, ProgressionCondition.EventType.ENDERFEATHER_USE);
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            ProgressionEventHandler.tickConditionsOfType((PlayerEntity)event.getEntityLiving(), event, ProgressionCondition.EventType.EQUIPMENT_CHANGE);
        }
    }

    public static void confirmExistingAdvancements(PlayerEntity player) {
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null || progression.getTier() >= 5) {
            return;
        }
        List conditions = ProgressionHelper.getConditionsForTierExcluding(progression.getTier(), ProgressionCondition.EventType.ADVANCEMENT, progression.getCompletedProgressionSteps()).stream().map(e -> e).collect(Collectors.toList());
        PlayerAdvancements advancements = ((ServerWorld)player.field_70170_p).func_73046_m().func_184103_al().func_192054_h((ServerPlayerEntity)player);
        AdvancementManager advancementMgr = ((ServerWorld)player.field_70170_p).func_73046_m().func_191949_aK();
        for (ProgressionCondition condition : conditions) {
            for (Advancement adv : advancementMgr.func_195438_b()) {
                AdvancementEvent evt;
                if (!advancements.func_192747_a(adv).func_192105_a() || !condition.isMet(evt = new AdvancementEvent(player, adv))) continue;
                progression.addTierProgressionComplete(condition.getRegistryName());
            }
        }
    }
}

