/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.api.items.IShowHud;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.items.ItemInit;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemCrystalOfMemories
extends TieredItem
implements IShowHud {
    private static final String KEY_MODE = "memory_crystal_fragment_mode";
    private static final int MODE_INFUSE = 0;
    private static final int MODE_SUPPLEMENT = 1;
    private static final String KEY_STORED_XP = "stored_xp";
    private static final int MAX_XP = 20000;

    public ItemCrystalOfMemories() {
        super(new Item.Properties().func_200918_c(100).setNoRepair().func_200916_a(MAItemGroups.items));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    private int getContainedXP(ItemStack stack) {
        if (!stack.func_77942_o() || stack.func_77973_b() != ItemInit.CRYSTAL_OF_MEMORIES.get()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(KEY_STORED_XP);
    }

    private void storeContainedXP(ItemStack stack, int amount) {
        if (stack.func_77973_b() != ItemInit.CRYSTAL_OF_MEMORIES.get()) {
            return;
        }
        stack.func_196082_o().func_74768_a(KEY_STORED_XP, amount);
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        if (living instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)living;
            int contained_xp = this.getContainedXP(stack);
            if (!living.field_70170_p.field_72995_K) {
                switch (this.getMode(stack)) {
                    case 1: {
                        if (contained_xp == 0) {
                            return;
                        }
                        int xp_to_give = Math.max(p.field_71068_ca, 1);
                        if (contained_xp < xp_to_give) {
                            xp_to_give = contained_xp;
                        }
                        p.func_195068_e(xp_to_give);
                        this.storeContainedXP(stack, contained_xp - xp_to_give);
                        break;
                    }
                    default: {
                        int xp_to_store;
                        if (contained_xp == 20000 || p.field_71067_cb == 0) {
                            return;
                        }
                        int n = xp_to_store = p.field_71068_ca == 0 ? 1 : p.field_71068_ca;
                        if (contained_xp + xp_to_store > 20000) {
                            xp_to_store = 20000 - contained_xp;
                        }
                        p.func_195068_e(-xp_to_store);
                        this.storeContainedXP(stack, Math.min(contained_xp + xp_to_store, 20000));
                    }
                }
            }
        }
        if (living.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                living.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), living.func_226277_ct_() - 0.5 + Math.random(), living.func_226278_cu_() + Math.random(), living.func_226281_cx_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (!worldIn.field_72995_K) {
                if (this.getMode(stack) == 0) {
                    this.setMode(stack, 1);
                } else {
                    this.setMode(stack, 0);
                }
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public int getMode(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(KEY_MODE)) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(KEY_MODE);
    }

    private void setMode(ItemStack stack, int mode) {
        stack.func_196082_o().func_74768_a(KEY_MODE, mode);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int contained_xp = this.getContainedXP(stack);
        if (contained_xp == 20000) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.full", new Object[]{stack.func_77958_k()}).func_240699_a_(TextFormatting.ITALIC));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.contains", new Object[]{contained_xp, 20000}).func_240699_a_(TextFormatting.ITALIC));
        }
        switch (this.getMode(stack)) {
            case 1: {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.supplement"));
                break;
            }
            default: {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.infusion"));
            }
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        float xp = this.getContainedXP(stack);
        return 1.0f - xp / 20000.0f;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ColorHelper.PackedColor.func_233006_a_((int)255, (int)128, (int)64, (int)255);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

