/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.ritual;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.rituals.RitualBlockPos;
import com.ma.api.rituals.RitualEffect;
import com.ma.blocks.BlockInit;
import com.ma.blocks.ritual.ChalkRuneBlock;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityRitual;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.rituals.MatchedRitual;
import com.ma.rituals.RitualInit;
import com.ma.rituals.contexts.RitualCheckContext;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ItemPurifiedVinteumDust
extends TieredItem {
    public ItemPurifiedVinteumDust(Item.Properties properties) {
        super(new Item.Properties().func_200916_a(MAItemGroups.items));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IPlayerMagic magic = (IPlayerMagic)context.func_195999_j().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        IPlayerProgression progression = (IPlayerProgression)context.func_195999_j().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return ActionResultType.FAIL;
        }
        if (!context.func_195991_k().field_72995_K && context.func_195999_j().func_225608_bj_() && context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == BlockInit.CHALK_RUNE.get()) {
            this.commandRitualEntity(context, (NonNullList<RitualBlockPos>)NonNullList.func_191196_a());
            return ActionResultType.SUCCESS;
        }
        MatchedRitual ritualMatch = RitualRecipe.matchAnyInWorld(context.func_195995_a(), context.func_195991_k());
        if (ritualMatch != null) {
            if (context.func_195991_k().field_72995_K) {
                this.spawnClientParticles(context);
            } else {
                ITextComponent cantStartReason;
                RitualEffect matchedEffect = RitualInit.RITUAL_EFFECTS.getValues().stream().filter(r -> r.matchRitual(ritualMatch.getRitual().func_199560_c())).findFirst().orElse(null);
                if (matchedEffect == null) {
                    context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:ritual-no-handler"), Util.field_240973_b_);
                    return ActionResultType.FAIL;
                }
                if (ritualMatch.getRitual().getTier() > progression.getTier()) {
                    context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:ritual-start-tier-fail"), Util.field_240973_b_);
                    return ActionResultType.FAIL;
                }
                if ((!context.func_195999_j().func_184812_l_() || matchedEffect.applyStartCheckInCreative()) && (cantStartReason = matchedEffect.canRitualStart(new RitualCheckContext(context.func_195999_j(), (ServerWorld)context.func_195991_k(), ritualMatch.getRitual(), context.func_195995_a(), this.getRitualAbove(context)))) != null) {
                    context.func_195999_j().func_145747_a(cantStartReason, Util.field_240973_b_);
                    return ActionResultType.FAIL;
                }
                this.updateBlockStates(context, ritualMatch.getPositions(), true);
                RitualInteractResult result = this.commandRitualEntity(context, ritualMatch.getPositions());
                if (result == RitualInteractResult.SPAWN) {
                    this.spawnRitualEntity(context, ritualMatch.getRitual(), ritualMatch.getPositions());
                } else if (result == RitualInteractResult.STARTED && !context.func_195999_j().func_225608_bj_()) {
                    context.func_195996_i().func_190918_g(1);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void spawnClientParticles(ItemUseContext context) {
        for (int i = 0; i < 50; ++i) {
            context.func_195991_k().func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_RANDOM.get())), (double)((float)context.func_195995_a().func_177958_n() + context.func_195991_k().func_201674_k().nextFloat() * 10.0f - 5.0f), (double)((float)context.func_195995_a().func_177956_o() + context.func_195991_k().func_201674_k().nextFloat()), (double)((float)context.func_195995_a().func_177952_p() + context.func_195991_k().func_201674_k().nextFloat() * 10.0f - 5.0f), 0.0, 0.0, 0.0);
        }
    }

    private void updateBlockStates(ItemUseContext context, NonNullList<RitualBlockPos> matchedPositions, boolean activated) {
        for (RitualBlockPos position : matchedPositions) {
            BlockState state = context.func_195991_k().func_180495_p(position.getBlockPos());
            BlockState newState = (BlockState)state.func_206870_a((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(activated));
            context.func_195991_k().func_175656_a(position.getBlockPos(), newState);
            context.func_195991_k().func_184138_a(position.getBlockPos(), state, newState, 2);
        }
    }

    private EntityRitual getRitualAbove(ItemUseContext context) {
        List entities = context.func_195991_k().func_175674_a((Entity)context.func_195999_j(), new AxisAlignedBB(context.func_195995_a()).func_186662_g(2.0), e -> e.func_200600_R() == EntityInit.RITUAL_ENTITY.get());
        Entity ritualEntity = null;
        if (entities != null && entities.size() == 1 && (ritualEntity = (Entity)entities.get(0)) instanceof EntityRitual) {
            return (EntityRitual)ritualEntity;
        }
        return null;
    }

    private RitualInteractResult commandRitualEntity(ItemUseContext context, NonNullList<RitualBlockPos> matchedPositions) {
        EntityRitual ritualEntity = this.getRitualAbove(context);
        if (ritualEntity != null) {
            if (context.func_195999_j().func_213453_ef()) {
                if (ritualEntity.cancelRitual()) {
                    return RitualInteractResult.CANCELED;
                }
            } else if (ritualEntity.confirmRitualReagents()) {
                return RitualInteractResult.STARTED;
            }
            return RitualInteractResult.NO_ACTION;
        }
        return RitualInteractResult.SPAWN;
    }

    private boolean spawnRitualEntity(ItemUseContext context, RitualRecipe ritual, NonNullList<RitualBlockPos> matchedPositions) {
        if (context.func_195999_j() == null) {
            ManaAndArtifice.LOGGER.error("Received a null player reference when trying to spawn a ritual.  This shouln't happen and something has messed with vanilla code!  Aborting.");
            return false;
        }
        if (context.func_195999_j().func_110124_au() == null) {
            ManaAndArtifice.LOGGER.error("Unable to resolve UUID for a player.  This shouln't happen and something has messed with vanilla code!  Aborting.");
            return false;
        }
        MutableBoolean success = new MutableBoolean(false);
        context.func_195999_j().getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            float speed = Math.max(1.0f - 0.2f * (float)(p.getTier() - ritual.getTier()), 0.2f);
            EntityRitual ritualEntity = new EntityRitual((EntityType<? extends EntityRitual>)((EntityType)EntityInit.RITUAL_ENTITY.get()), context.func_195991_k());
            BlockPos ritualSpawnPos = context.func_195995_a();
            ritualEntity.func_70107_b((float)ritualSpawnPos.func_177958_n() + 0.5f, ritualSpawnPos.func_177956_o(), (float)ritualSpawnPos.func_177952_p() + 0.5f);
            ritualEntity.setRitualBlockLocations(matchedPositions);
            ritualEntity.setRitualName(ritual.func_199560_c());
            ritualEntity.setSpeed(speed);
            ritualEntity.setCasterUUID(context.func_195999_j().func_110124_au());
            context.func_195991_k().func_217376_c((Entity)ritualEntity);
            success.setTrue();
        });
        return success.getValue();
    }

    static enum RitualInteractResult {
        SPAWN,
        UPDATED,
        STARTED,
        CANCELED,
        NO_ACTION;

    }
}

