/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.Registries;
import com.ma.api.capabilities.Faction;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.parts.Component;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.ItemAndPatternRecipe;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import com.ma.tools.MATags;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeSpellPart
extends RecipeRendererBase {
    ItemAndPatternRecipe recipe;
    ISpellComponent output;
    ArrayList<List<ItemStack>> reagents = new ArrayList();

    public RecipeSpellPart(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        ItemStack affinity;
        if (this.recipe == null) {
            return;
        }
        this.renderSpellIcon(matrixStack, x, y);
        this.renderManaweavePatterns(matrixStack, x, y);
        this.renderRecipeStack(0, x + 41, y + 44);
        this.renderRecipeStack(1, x + 162, y + 159);
        this.renderRecipeStack(2, x + 41, y + 159);
        this.renderRecipeStack(3, x + 162, y + 44);
        this.renderRecipeStack(4, x + 41, y + 101);
        this.renderRecipeStack(5, x + 162, y + 101);
        this.renderRecipeStack(6, x + 101, y + 44);
        this.renderRecipeStack(7, x + 101, y + 159);
        FontRenderer fr = this.minecraft.field_71466_p;
        int tier = this.recipe.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
        TranslationTextComponent name = new TranslationTextComponent(this.output.getRegistryName().toString());
        TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
        int stringWidth = fr.func_238414_a_((ITextProperties)name);
        int textX = x + this.field_230688_j_ / 2 - stringWidth / 2;
        int textY = 10;
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name) / 2), (float)(y + textY), ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), (float)(y + textY + 10), color);
        if (this.output.getFactionRequirement() != Faction.NONE) {
            int xPadding = 3;
            this.renderFactionIcon(matrixStack, this.output.getFactionRequirement(), textX + stringWidth + xPadding, y + textY);
        }
        if (this.output instanceof Component && !(affinity = GuiTextures.affinityIcons.getOrDefault((Object)((Component)this.output).getAffinity(), ItemStack.field_190927_a)).func_190926_b()) {
            this.renderItemStack(affinity, textX - 19, y + 5);
        }
    }

    private void renderRecipeStack(int index, int x, int y) {
        if (index >= this.reagents.size()) {
            return;
        }
        this.renderItemStack(this.reagents.get(index), x, y + 1);
    }

    private void renderManaweavePatterns(MatrixStack matrixStack, int x, int y) {
        this.minecraft.func_110434_K().func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        float patternScale = 0.1f;
        int POINT_RENDER_SIZE = 13;
        int startX = (int)((float)(x + 31) / patternScale);
        int startY = (int)((float)(y + 225) / patternScale);
        RenderSystem.color3f((float)0.5f, (float)0.0f, (float)1.0f);
        for (int i = 0; i < this.recipe.getRequiredPatterns().length; ++i) {
            ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe((World)this.minecraft.field_71441_e, this.recipe.getRequiredPatterns()[i]);
            if (p == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)patternScale, (float)patternScale, (float)patternScale);
            byte[][] pData = p.get();
            int pointSize = 13;
            for (int k = 0; k < pData.length; ++k) {
                for (int j = 0; j < pData[k].length; ++j) {
                    if (pData[k][j] == 0) continue;
                    this.func_238474_b_(matrixStack, startX - j * pointSize, startY + k * pointSize, 0, 0, POINT_RENDER_SIZE, POINT_RENDER_SIZE);
                }
            }
            RenderSystem.popMatrix();
            startX = (int)((float)startX + 34.0f / patternScale);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSpellIcon(MatrixStack matrixStack, int x, int y) {
        if (this.output != null) {
            this.minecraft.func_110434_K().func_110577_a(this.output.getGuiIcon());
            RecipeSpellPart.func_238463_a_((MatrixStack)matrixStack, (int)(x + 102), (int)(y + 101), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_SPELLPART;
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
            this.recipe = (ItemAndPatternRecipe)pattern.get();
        }
        if (this.recipe != null) {
            ResourceLocation rLoc = this.recipe.getOutput();
            if (rLoc.func_110624_b().equals("mana-and-artifice")) {
                rLoc = new ResourceLocation("mana-and-artifice", "shapes/" + this.recipe.getOutput().func_110623_a());
                this.output = (ISpellComponent)Registries.Shape.getValue(rLoc);
                if (this.output == null) {
                    rLoc = new ResourceLocation("mana-and-artifice", "components/" + this.recipe.getOutput().func_110623_a());
                    this.output = (ISpellComponent)Registries.Component.getValue(rLoc);
                }
                if (this.output == null) {
                    rLoc = new ResourceLocation("mana-and-artifice", "modifiers/" + this.recipe.getOutput().func_110623_a());
                    this.output = (ISpellComponent)Registries.Modifier.getValue(rLoc);
                }
            } else {
                this.output = (ISpellComponent)Registries.Shape.getValue(this.recipe.getOutput());
                if (this.output == null) {
                    this.output = (ISpellComponent)Registries.Component.getValue(this.recipe.getOutput());
                }
                if (this.output == null) {
                    this.output = (ISpellComponent)Registries.Modifier.getValue(this.recipe.getOutput());
                }
            }
            for (int i = 0; i < this.recipe.getRequiredItems().length; ++i) {
                this.reagents.add(MATags.smartLookupItem(this.recipe.getRequiredItems()[i]).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList()));
            }
        }
    }

    @Override
    public int getTier() {
        return this.recipe != null ? this.recipe.getTier() : 1;
    }
}

