/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.api.capabilities.Faction;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.runeforging.RuneforgingRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeRunesmith
extends RecipeRendererBase {
    private RuneforgingRecipe pattern;
    static final int POINT_RENDER_SIZE = 13;
    private ItemStack _metal;
    private ItemStack _pattern;
    private ItemStack _output;

    public RecipeRunesmith(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof RuneforgingRecipe) {
            this.pattern = (RuneforgingRecipe)pattern.get();
            this._metal = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(this.pattern.getMaterial()));
            this._pattern = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(this.pattern.getPatternResource()));
            this._output = this.pattern.func_77571_b();
        } else {
            this.pattern = null;
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_RUNESMITHING;
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.pattern == null) {
            return;
        }
        this.minecraft.field_71446_o.func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        this.renderItemStack(this._pattern, x + 42, y + 107);
        this.renderItemStack(this._metal, x + 42, y + 61);
        this.renderItemStack(this._output, x + 178, y + 89);
        String hits = String.format("x %d", this.pattern.getHits());
        this.minecraft.field_71466_p.func_238421_b_(matrixStack, hits, (float)(x + 123 - this.minecraft.field_71466_p.func_78256_a(hits) / 2), (float)(y + 100), ColorHelper.PackedColor.func_233006_a_((int)255, (int)71, (int)71, (int)71));
        if (this._output.func_190916_E() > 1) {
            String count = String.format("x %d", this._output.func_190916_E());
            this.minecraft.field_71466_p.func_238421_b_(matrixStack, count, (float)(x + 186 - this.minecraft.field_71466_p.func_78256_a(count) / 2), (float)(y + 110), ColorHelper.PackedColor.func_233006_a_((int)255, (int)71, (int)71, (int)71));
        }
        int tier = this.pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
        TranslationTextComponent name = new TranslationTextComponent(this.pattern.func_77571_b().func_77977_a().toString());
        TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
        int stringWidth = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name);
        int textX = x + this.field_230688_j_ / 2 - stringWidth / 2;
        int textY = y + 5;
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), (float)(y + 15), color);
        if (this.pattern.getFactionRequirement() != Faction.NONE) {
            int xPadding = 3;
            this.renderFactionIcon(matrixStack, this.pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    public int getTier() {
        return this.pattern != null ? this.pattern.getTier() : 1;
    }
}

