/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.api.capabilities.Faction;
import com.ma.api.rituals.IRitualReagent;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.recipes.rituals.RitualRecipeHelper;
import com.ma.tools.MATags;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeRitual
extends RecipeRendererBase {
    private RitualRecipe pattern;
    static final int POINT_RENDER_SIZE = 13;

    public RecipeRitual(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        this.pattern = RitualRecipeHelper.GetRitualRecipe((World)this.minecraft.field_71441_e, recipeLocation);
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return null;
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int i;
        if (this.pattern == null) {
            return;
        }
        int startX = x + this.field_230688_j_ - 54;
        int startY = y + 60;
        int pointSize = (this.field_230688_j_ - 80) / this.pattern.getPattern().length;
        int centerOffset = (pointSize - 13) / 2;
        int[][] pData = this.pattern.getPattern();
        IRitualReagent[][] reagents = this.pattern.getReagents();
        this.minecraft.field_71446_o.func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        RenderSystem.disableDepthTest();
        for (int i2 = 0; i2 < pData.length; ++i2) {
            for (int j = 0; j < pData[i2].length; ++j) {
                if (pData[i2][j] == 0) continue;
                this.func_238474_b_(matrixStack, startX - j * pointSize - centerOffset, startY + i2 * pointSize + centerOffset, 13, 0, 13, 13);
            }
        }
        RenderSystem.enableDepthTest();
        int gridWidth = pData.length * pointSize;
        int gridTop = startY;
        int gridLeft = startX + pointSize - gridWidth - centerOffset - (pointSize - 13) / 2;
        for (i = 0; i <= pData.length; ++i) {
            GuiRenderUtils.line2d(gridLeft, gridTop + pointSize * i, gridLeft + gridWidth, gridTop + pointSize * i, 0.0f, 7825228);
            GuiRenderUtils.line2d(gridLeft + pointSize * i, gridTop, gridLeft + pointSize * i, gridTop + gridWidth, 0.0f, 7825228);
        }
        for (i = 0; i < reagents.length; ++i) {
            for (int j = 0; j < reagents[i].length; ++j) {
                if (reagents[i][j] == null || reagents[i][j].isDynamic()) continue;
                this.renderItemStack(MATags.smartLookupItem(reagents[i][j].getResourceLocation()).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList()), startX - 1 - j * pointSize - centerOffset, startY - 1 + i * pointSize + centerOffset);
            }
        }
        int tier = this.pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
        TranslationTextComponent name = new TranslationTextComponent(this.pattern.func_199560_c().toString());
        TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
        String patternSize = String.format("%dx%d", this.pattern.getPattern().length, this.pattern.getPattern().length);
        int stringWidth = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name);
        int textX = x + this.field_230688_j_ / 2 - stringWidth / 2;
        int textY = y + 5;
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), (float)(y + 15), color);
        this.minecraft.field_71466_p.func_238421_b_(matrixStack, patternSize, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_78256_a(patternSize) / 2), (float)(y + 35), 0x404040);
        if (this.pattern.getFactionRequirement() != Faction.NONE) {
            int xPadding = 3;
            this.renderFactionIcon(matrixStack, this.pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    public int getTier() {
        return this.pattern != null ? this.pattern.getTier() : 1;
    }
}

