/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.item;

import com.ma.gui.containers.ContainerInit;
import com.ma.items.ItemInit;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.MATags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ContainerSpellRecipe
extends Container {
    private List<List<ItemStack>> _cachedSpellRecipeReagents = new ArrayList<List<ItemStack>>();

    protected ContainerSpellRecipe(ContainerType<?> type, int id) {
        super(type, id);
    }

    public ContainerSpellRecipe(int i, PlayerInventory playerInv) {
        super(ContainerInit.SPELL_RECIPE_LIST, i);
        if (playerInv.field_70458_d.func_184614_ca().func_77973_b() == ItemInit.ENCHANTED_VELLUM.get()) {
            this.pullRecipeReagentsFromStack(playerInv.field_70458_d.func_184614_ca());
        } else if (playerInv.field_70458_d.func_184592_cb().func_77973_b() == ItemInit.ENCHANTED_VELLUM.get()) {
            this.pullRecipeReagentsFromStack(playerInv.field_70458_d.func_184592_cb());
        }
    }

    private void pullRecipeReagentsFromStack(ItemStack stack) {
        HashMap<ResourceLocation, Integer> reagentIDsMerged = new HashMap<ResourceLocation, Integer>();
        SpellRecipe.getShapeReagents(stack).stream().forEach(r -> {
            if (reagentIDsMerged.containsKey(r)) {
                reagentIDsMerged.put((ResourceLocation)r, (Integer)reagentIDsMerged.get(r) + 1);
            } else {
                reagentIDsMerged.put((ResourceLocation)r, 1);
            }
        });
        SpellRecipe.getComponentReagents(stack).stream().forEach(r -> {
            if (reagentIDsMerged.containsKey(r)) {
                reagentIDsMerged.put((ResourceLocation)r, (Integer)reagentIDsMerged.get(r) + 1);
            } else {
                reagentIDsMerged.put((ResourceLocation)r, 1);
            }
        });
        for (int i = 0; i < 3; ++i) {
            SpellRecipe.getModifierReagents(stack, i).stream().forEach(r -> {
                if (reagentIDsMerged.containsKey(r)) {
                    reagentIDsMerged.put((ResourceLocation)r, (Integer)reagentIDsMerged.get(r) + 1);
                } else {
                    reagentIDsMerged.put((ResourceLocation)r, 1);
                }
            });
        }
        SpellRecipe.getComplexityReagents(stack).stream().forEach(r -> {
            if (reagentIDsMerged.containsKey(r)) {
                reagentIDsMerged.put((ResourceLocation)r, (Integer)reagentIDsMerged.get(r) + 1);
            } else {
                reagentIDsMerged.put((ResourceLocation)r, 1);
            }
        });
        this._cachedSpellRecipeReagents.addAll((Collection<List<ItemStack>>)this.resolveReagents(reagentIDsMerged));
    }

    private NonNullList<List<ItemStack>> resolveReagents(HashMap<ResourceLocation, Integer> reagentIDs) {
        NonNullList resolved = NonNullList.func_191196_a();
        for (ResourceLocation rLoc : reagentIDs.keySet()) {
            resolved.add(MATags.smartLookupItem(rLoc).stream().map(i -> new ItemStack((IItemProvider)i, ((Integer)reagentIDs.get(rLoc)).intValue())).collect(Collectors.toList()));
        }
        return resolved;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public List<List<ItemStack>> getReagents() {
        return this._cachedSpellRecipeReagents;
    }
}

