/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers;

import com.ma.gui.containers.slots.BaseSlot;
import com.ma.inventory.ItemInventoryBase;
import com.ma.items.IBagItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public abstract class HeldContainerBase
extends Container {
    public ItemInventoryBase inventory;
    public int bagHash;
    protected int mySlot;
    private int myPlayerIndex;

    public abstract BaseSlot slot(IItemHandler var1, int var2, int var3, int var4);

    public HeldContainerBase(@Nullable ContainerType<?> type, int id, PlayerInventory playerInv, ItemInventoryBase basebag) {
        super(type, id);
        this.inventory = basebag;
        this.bagHash = basebag.getStack().hashCode();
        this.myPlayerIndex = playerInv.field_70461_c;
        this.initializeSlots(playerInv);
    }

    protected abstract int slotsPerRow();

    protected abstract int numRows();

    protected void initializeSlots(PlayerInventory playerInv) {
        int slotIndex = 0;
        for (int j = 0; j < this.numRows(); ++j) {
            for (int k = 0; k < this.slotsPerRow(); ++k) {
                this.func_75146_a((Slot)this.slot((IItemHandler)this.inventory, k + j * this.slotsPerRow(), 8 + k * 18, 8 + j * 18));
                ++slotIndex;
            }
        }
        int i = (this.numRows() - 4) * 18;
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInv, j1 + l * 9 + 9, 8 + j1 * 18, 94 + l * 18 + i));
                ++slotIndex;
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            if (i1 == playerInv.field_70461_c) {
                this.mySlot = slotIndex;
            }
            this.func_75146_a(new Slot((IInventory)playerInv, i1, 8 + i1 * 18, 152 + i));
            ++slotIndex;
        }
    }

    public int size() {
        return this.numRows() * this.slotsPerRow();
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId == this.mySlot || clickTypeIn == ClickType.SWAP && dragType == this.myPlayerIndex) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.inventory.writeItemStack();
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        ItemStack held = player.func_184614_ca();
        return held == this.inventory.getStack() && !this.inventory.getStack().func_190926_b() && held.hashCode() == this.bagHash && held.func_77973_b() instanceof IBagItem;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.numRows() * this.slotsPerRow() ? !this.func_75135_a(itemstack1, this.numRows() * this.slotsPerRow(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.numRows() * this.slotsPerRow(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

