/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.block;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.events.ClientEventHandler;
import com.ma.gui.GuiTextures;
import com.ma.gui.containers.block.ContainerLodestar;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiLodestar
extends ContainerScreen<ContainerLodestar> {
    private int sub_x_origin = 44;
    private int arrow_x_origin = 62;
    private int arrow_y_origin = 9;
    private int sub_x = this.sub_x_origin;
    private int sub_y = 5;
    private int action_y_coord = 5;
    private int action_x_coord = 5;
    private int action_button_spacing = 30;
    private int row_height = 18;
    private int items_per_row = 7;
    int i;
    int j;
    private ArrayList<CommandButton> commandButtons;
    private ITextComponent currentTooltip;

    public GuiLodestar(ContainerLodestar screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 256;
        this.field_147000_g = 173;
        this.commandButtons = new ArrayList();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.commandButtons.clear();
        this.i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.j = (this.field_230709_l_ - this.field_147000_g) / 2;
        for (ConstructActions a : ConstructActions.values()) {
            if (!a.isLodestarAssignable()) continue;
            this.addActionButton(a);
        }
        for (int i = 0; i < ((ContainerLodestar)this.field_147002_h).getCommandCount(); ++i) {
            ConstructCommand cmd = ((ContainerLodestar)this.field_147002_h).getCommand(i);
            if (cmd == null) continue;
            this.addSubButton(cmd.getType(), i, false);
        }
    }

    private void addActionButton(ConstructActions type) {
        this.func_230480_a_((Widget)new CommandButton(this.field_147003_i + this.action_x_coord, this.field_147009_r + this.action_y_coord, button -> this.addSubButton(type, this.commandButtons.size(), true), type, -1));
        this.action_y_coord += 18;
        if (this.action_y_coord > 149) {
            this.action_y_coord = 5;
            this.action_x_coord += 19;
        }
    }

    private void addSubButton(ConstructActions type, int index, boolean container_interact) {
        if (index > this.arrow_x_origin || type.getAIClass() == null) {
            return;
        }
        if (container_interact) {
            ((ContainerLodestar)this.field_147002_h).addCommand(type);
        }
        CommandButton cmdBtn = new CommandButton(this.field_147003_i + this.sub_x, this.field_147009_r + this.sub_y, btn -> {
            if (ClientEventHandler.isKeyDown(this.field_230706_i_.field_71474_y.field_74313_G)) {
                this.removeButton((CommandButton)btn);
            } else {
                this.openCommandEditor((CommandButton)btn);
            }
        }, type, index);
        this.commandButtons.add(cmdBtn);
        this.func_230480_a_((Widget)cmdBtn);
        this.sub_x += this.action_button_spacing;
        if (this.sub_x > this.field_146999_f - this.action_button_spacing) {
            this.sub_x = this.sub_x_origin;
            this.sub_y += this.row_height;
        }
    }

    private void openCommandEditor(CommandButton btn) {
        ((ContainerLodestar)this.field_147002_h).openCommandEditor((PlayerEntity)this.field_230706_i_.field_71439_g, btn.type, btn.index);
    }

    private void removeButton(CommandButton btn) {
        int idx = this.commandButtons.indexOf((Object)btn);
        this.field_230705_e_.remove((Object)btn);
        this.field_230710_m_.remove((Object)btn);
        this.commandButtons.remove(idx);
        ((ContainerLodestar)this.field_147002_h).removeCommand(btn.type, idx);
        for (int i = idx; i < this.commandButtons.size(); ++i) {
            CommandButton cmdBtn = this.commandButtons.get(i);
            if (cmdBtn == null) continue;
            cmdBtn.setIndex(cmdBtn.getIndex() - 1);
            cmdBtn.field_230690_l_ -= this.action_button_spacing;
            if (cmdBtn.field_230690_l_ >= this.field_147003_i + this.sub_x_origin) continue;
            cmdBtn.field_230690_l_ = this.field_147003_i + this.sub_x_origin + this.action_button_spacing * (this.items_per_row - 1);
            cmdBtn.field_230691_m_ -= this.row_height;
        }
        this.sub_x -= this.action_button_spacing;
        if (this.sub_x < this.sub_x_origin) {
            this.sub_x = this.sub_x_origin + this.action_button_spacing * (this.items_per_row - 1);
            this.sub_y -= this.row_height;
        }
    }

    private void blitArrow(MatrixStack stack, int x, int y) {
        this.func_238474_b_(stack, x, y, 32, 195, 10, 8);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip = null;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.currentTooltip == null) {
            this.func_230459_a_(matrixStack, mouseX, mouseY);
        } else {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        if (this.commandButtons.size() > 0) {
            this.field_230706_i_.field_71446_o.func_110577_a(GuiTextures.LODESTAR);
            int arrow_x = this.arrow_x_origin;
            int arrow_y = this.arrow_y_origin;
            for (int i = 1; i < this.commandButtons.size(); ++i) {
                this.blitArrow(matrixStack, arrow_x, arrow_y);
                if ((arrow_x += this.action_button_spacing) <= this.field_146999_f) continue;
                arrow_x = this.arrow_x_origin;
                arrow_y += this.row_height;
            }
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.LODESTAR);
        this.func_238474_b_(matrixStack, this.i, this.j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private class CommandButton
    extends ImageButton {
        private ConstructActions type;
        private int index;
        private TranslationTextComponent ttc;

        public CommandButton(int xIn, int yIn, Button.IPressable onPressIn, ConstructActions type, int index) {
            super(xIn, yIn, 16, 16, type.getTexX(), type.getTexY(), 0, GuiTextures.LODESTAR, onPressIn);
            this.type = type;
            this.index = index;
            this.ttc = type.getAIClass() == null ? (TranslationTextComponent)new TranslationTextComponent("gui.mana-and-artifice.command.coming-soon").func_240699_a_(TextFormatting.GOLD) : new TranslationTextComponent("gui.mana-and-artifice.command." + type.toString().toLowerCase());
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.field_230692_n_) {
                GuiLodestar.this.currentTooltip = (ITextComponent)this.ttc;
            }
        }
    }
}

