/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.targeting;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.entities.sorcery.base.ChanneledSpellEntity;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.BlockUtils;
import com.ma.tools.render.LineSegment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntitySpellWall
extends ChanneledSpellEntity {
    protected Vector3d forward;
    protected Vector3d perpendicular;

    public EntitySpellWall(EntityType<? extends EntitySpellWall> type, World world) {
        super(type, world);
    }

    public EntitySpellWall(PlayerEntity caster, ISpellDefinition spell, World world) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_WALL.get()), caster, spell, world);
        this.field_70177_z = caster.field_70177_z;
        this.field_70125_A = caster.field_70125_A;
    }

    protected EntitySpellWall(EntityType<? extends EntitySpellWall> entityType, PlayerEntity caster, ISpellDefinition spell, World world) {
        super(entityType, caster, spell, world);
        this.field_70177_z = caster.field_70177_z;
        this.field_70125_A = caster.field_70125_A;
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, PlayerEntity caster, ServerWorld world) {
        float radius_h = this.getShapeAttributeByAge(Attribute.WIDTH);
        float radius_v = this.getShapeAttributeByAge(Attribute.HEIGHT);
        SpellSource source = new SpellSource((LivingEntity)caster, caster.func_184600_cs());
        SpellContext context = new SpellContext(world, recipe, this);
        if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsEntities())) {
            for (Entity e : this.targetEntities(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
            }
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsBlocks())) {
            for (BlockPos p : this.targetBlocks(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(p, null).doNotOffsetFace(), context);
            }
        }
    }

    protected BlockPos[] targetBlocks(float radius_h, float radius_v) {
        double radiusOffsetX = Math.cos(Math.toRadians(this.field_70177_z)) * (double)radius_h;
        double radiusOffsetZ = Math.sin(Math.toRadians(this.field_70177_z)) * (double)radius_h;
        Vector3d a = new Vector3d(this.func_226277_ct_() + radiusOffsetX, this.func_226278_cu_(), this.func_226281_cx_() + radiusOffsetZ);
        Vector3d b = new Vector3d(this.func_226277_ct_() - radiusOffsetX, this.func_226278_cu_(), this.func_226281_cx_() - radiusOffsetZ);
        return this.getAllBlockLocationsBetween(a, b, radius_v);
    }

    protected BlockPos[] getAllBlockLocationsBetween(Vector3d a, Vector3d b, float radius_v) {
        ArrayList allPoints = new ArrayList();
        BlockUtils.stepThroughBlocksLinear(BlockUtils.Vector3dToBlockPosRound(a), BlockUtils.Vector3dToBlockPosRound(b), pos -> {
            int i = 0;
            while ((float)i < radius_v) {
                if (!allPoints.contains(pos.func_177982_a(0, i, 0))) {
                    allPoints.add(pos.func_177982_a(0, i, 0));
                }
                ++i;
            }
        });
        return allPoints.toArray(new BlockPos[0]);
    }

    protected List<Entity> targetEntities(float radius_h, float radius_v) {
        List possibleTargets = this.field_70170_p.func_217357_a(Entity.class, new AxisAlignedBB(this.func_226277_ct_() - (double)radius_h, this.func_226278_cu_(), this.func_226281_cx_() - (double)radius_h, this.func_226277_ct_() + (double)radius_h, this.func_226278_cu_() + (double)radius_v, this.func_226281_cx_() + (double)radius_h));
        ArrayList<Entity> targets = new ArrayList<Entity>();
        double dirX = Math.cos(Math.PI / 180 * (double)this.field_70177_z);
        double dirZ = Math.sin(Math.PI / 180 * (double)this.field_70177_z);
        Vector3d a = new Vector3d(this.func_226277_ct_() - dirX * (double)radius_h, this.func_226278_cu_(), this.func_226281_cx_() - dirZ * (double)radius_h);
        Vector3d b = new Vector3d(this.func_226277_ct_() - dirX * (double)(-radius_h), this.func_226278_cu_(), this.func_226281_cx_() - dirZ * (double)(-radius_h));
        LineSegment wallLine = new LineSegment(a, b);
        for (Entity e : possibleTargets) {
            if (e == this || e == this.getCaster()) continue;
            Vector3d target = e.func_213303_ch();
            Vector3d closest = wallLine.closestPointOnLine(target);
            target = target.func_178786_a(0.0, target.field_72448_b, 0.0);
            closest = closest.func_178786_a(0.0, closest.field_72448_b, 0.0);
            double hDist = Math.abs(closest.func_72438_d(target));
            double vDist = Math.abs(this.func_226278_cu_() - e.func_226278_cu_());
            if (!(hDist < 0.75) || !(vDist < (double)radius_v)) continue;
            targets.add(e);
        }
        return targets;
    }

    @Override
    public void setCaster(PlayerEntity player) {
        this.field_70125_A = player.field_70125_A;
        this.field_70177_z = player.field_70177_z;
        super.setCaster(player);
    }

    @Override
    protected void spawnAirParticles() {
        this.spawnParticlesAlongRadius((MAParticleType)ParticleInit.AIR_ORBIT.get(), new Vector3d((double)0.3f, (double)0.02f, (double)0.3f));
    }

    @Override
    protected void spawnEarthParticles() {
        this.spawnParticlesAlongRadius((MAParticleType)ParticleInit.DUST.get(), new Vector3d(0.0, (double)0.05f, 0.0));
    }

    @Override
    protected void spawnFireParticles(boolean hellfire, boolean lightning) {
        if (!lightning) {
            this.spawnParticlesAlongRadius(hellfire ? (MAParticleType)ParticleInit.HELLFIRE.get() : (MAParticleType)ParticleInit.FLAME.get(), new Vector3d(0.0, (double)(this.getShapeAttributeByAge(Attribute.HEIGHT) / 30.0f), 0.0));
        } else {
            this.spawnLightningParticlesAlongRadius(new Vector3d(-0.5 + Math.random(), Math.random(), -0.5 + Math.random()));
        }
    }

    @Override
    protected void spawnWaterParticles(boolean frost) {
        this.spawnParticlesAlongRadius(frost ? (MAParticleType)ParticleInit.FROST.get() : (MAParticleType)ParticleInit.WATER.get(), new Vector3d(0.0, (double)0.025f, 0.0));
    }

    @Override
    protected void spawnEnderParticles() {
        this.spawnParticlesAlongRadius((MAParticleType)ParticleInit.ENDER_VELOCITY.get(), new Vector3d(0.0, (double)0.025f, 0.0));
    }

    @Override
    protected void spawnArcaneParticles() {
        this.spawnParticlesAlongRadius((MAParticleType)ParticleInit.ARCANE.get(), new Vector3d(0.0, (double)0.025f, 0.0));
    }

    protected void spawnParticlesAlongRadius(MAParticleType particleData, Vector3d motionData) {
        this.spawnParticlesAlongRadius(particleData, motionData, true, false);
    }

    protected void spawnParticlesAlongRadius(MAParticleType particleData, Vector3d motionData, boolean randomY, boolean addPositionToMotionData) {
        if (this.forward == null) {
            float x = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float y = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float z = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
            this.forward = new Vector3d((double)x, (double)y, (double)z);
        }
        if (this.perpendicular == null) {
            this.perpendicular = this.forward.func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b();
        }
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        float height = this.getShapeAttributeByAge(Attribute.HEIGHT);
        int i = 0;
        while ((float)i < 20.0f * radius * (height / 2.0f)) {
            double radiusMid = Math.random() * (double)radius * 2.0 - (double)radius;
            Vector3d particleOrigin = new Vector3d(me.field_72450_a - this.perpendicular.field_72450_a * radiusMid, randomY ? me.field_72448_b + Math.random() * (double)height : me.field_72448_b, me.field_72449_c - this.perpendicular.field_72449_c * radiusMid);
            Vector3d particleMotion = addPositionToMotionData ? motionData.func_178787_e(particleOrigin) : motionData;
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType(particleData), particleOrigin.field_72450_a, particleOrigin.field_72448_b, particleOrigin.field_72449_c, particleMotion.field_72450_a, particleMotion.field_72448_b, particleMotion.field_72449_c);
            ++i;
        }
    }

    protected void spawnLightningParticlesAlongRadius(Vector3d motionData) {
        if (this.forward == null) {
            float x = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float y = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float z = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
            this.forward = new Vector3d((double)x, (double)y, (double)z);
        }
        if (this.perpendicular == null) {
            this.perpendicular = this.forward.func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b();
        }
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        float height = this.getShapeAttributeByAge(Attribute.HEIGHT);
        int i = 0;
        while ((float)i < 2.0f * radius) {
            double radiusMid = Math.random() * (double)radius * 2.0 - (double)radius;
            Vector3d particleOrigin = new Vector3d(me.field_72450_a - this.perpendicular.field_72450_a * radiusMid, me.field_72448_b, me.field_72449_c - this.perpendicular.field_72449_c * radiusMid);
            Vector3d particleMotion = motionData.func_178787_e(particleOrigin);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), particleOrigin.field_72450_a, particleOrigin.field_72448_b, particleOrigin.field_72449_c, particleMotion.field_72450_a, particleMotion.field_72448_b + (double)height, particleMotion.field_72449_c);
            ++i;
        }
    }
}

