/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.ai.FactionTierWrapperGoal;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.block.SoundType;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityMushroomSoldier
extends MonsterEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener<EntityMushroomSoldier>,
IAnimPacketSync<EntityMushroomSoldier>,
IFactionEnemy<EntityMushroomSoldier>,
IEntityAdditionalSpawnData {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_FLING = "fling";
    private static final String INSTRUCTION_HEAL = "heal";
    private static final String INSTRUCTION_BURROW_POS = "burrow_position";
    private static final String INSTRUCTION_BURROW_FLING = "burrow_attack";
    private static final int SKY_ATTACK_CD = 300;
    private static final int BURROW_CD = 300;
    private static final int HEAL_CD = 1200;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private Entity attackEntity;
    private int skyAttackCooldown = 0;
    private int burrowCooldown = 0;
    private int healCooldown = 0;
    private boolean isActing = false;
    private boolean isMeleeAttacking = false;
    private boolean isSkyAttacking = false;
    private boolean isBurrowing = false;
    private boolean isHealing = false;
    private PlayerEntity raidTarget;
    private int tier;
    private HashMap<String, Integer> damageResists = new HashMap();

    public EntityMushroomSoldier(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.2f;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().transitionLengthTicks = 2.0;
        if (!this.isActing) {
            if (this.func_213322_ci().func_72433_c() > (double)0.1f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.walk", Boolean.valueOf(true)));
            } else if (this.func_70638_az() != null) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.combat_idle", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.idle", Boolean.valueOf(true)));
            }
        } else if (this.isSkyAttacking) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.skyattack", Boolean.valueOf(false)));
        } else if (this.isBurrowing) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.burrow", Boolean.valueOf(false)));
        } else if (this.isHealing) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.heal", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.attack", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    public SoundEvent func_184639_G() {
        return SoundEvents.field_219600_M;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219600_M;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232702_eA_;
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    @Override
    public Faction getFaction() {
        return Faction.FEY_COURT;
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return this.damageResists;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isBurrowing && !source.func_76363_c()) {
            return false;
        }
        amount = this.applyDamageResists(source, amount);
        return super.func_70097_a(source, amount);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("tier_health_bonus", (double)(tier + 1), AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("tier_armor_bonus", (double)(5 * tier), AttributeModifier.Operation.ADDITION));
        this.func_70606_j(this.func_110138_aP());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeFactionData(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readFactionData(compound);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.skyAttackCooldown;
        --this.burrowCooldown;
        --this.healCooldown;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.applyInitialSpawnTier((IWorld)worldIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FactionTierWrapperGoal(1, this, new HealGoal()));
        this.field_70714_bg.func_75776_a(2, (Goal)new FactionTierWrapperGoal(2, this, new BurrowGoal()));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, (double)0.35f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, this::factionTargetHelpPredicate));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void func_226292_a_(Hand p_226292_1_, boolean p_226292_2_) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isMeleeAttacking = true;
        this.isActing = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.isMeleeAttacking) {
            return true;
        }
        if (this.skyAttackCooldown <= 0) {
            this.isSkyAttacking = true;
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_FLING, 30, entityIn, this::handleDelayCallback));
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 45, "", this::handleDelayCallback));
        } else {
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        }
        this.isActing = true;
        this.isMeleeAttacking = false;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.attackEntity = entityIn;
        return true;
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SFX.Entity.Generic.WOOSH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
            }
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.maybeDisableShield(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
            if (this.field_70146_Z.nextFloat() < 0.2f && entityIn instanceof MobEntity) {
                ((MobEntity)entityIn).func_70624_b((LivingEntity)this);
            }
        }
        return flag;
    }

    private void maybeDisableShield(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.55f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                switch (identifier) {
                    case "fling": {
                        entity.func_70024_g(0.0, 1.0, 0.0);
                        if (entity instanceof PlayerEntity) {
                            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                        }
                        this.func_184185_a(SFX.Entity.Generic.WOOSH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                        break;
                    }
                    case "damage": {
                        this.damageEntity(entity);
                        break;
                    }
                    case "heal": {
                        this.func_70691_i(this.func_110138_aP() * 0.5f);
                        break;
                    }
                    case "burrow_position": {
                        Vector3d pos = entity.func_213303_ch();
                        if (!(pos.func_72438_d(this.func_213303_ch()) < 64.0)) break;
                        Vector3d newPos = this.func_213303_ch().func_178788_d(pos).func_72432_b();
                        this.func_226286_f_(pos.field_72450_a + newPos.field_72450_a, pos.field_72448_b + newPos.field_72448_b, pos.field_72449_c + newPos.field_72449_c);
                        this.func_200602_a(EntityAnchorArgument.Type.FEET, pos);
                        break;
                    }
                    case "burrow_attack": {
                        Vector3d pos = entity.func_213303_ch();
                        this.func_184185_a(SFX.Spell.Impact.Single.EARTH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                        if (!(pos.func_72438_d(this.func_213303_ch()) < 2.0)) break;
                        this.handleDelayCallback(INSTRUCTION_FLING, entity);
                    }
                }
            } else {
                switch (identifier) {
                    case "heal": {
                        int i;
                        for (i = 0; i < 5; ++i) {
                            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 1.0, this.func_226287_g_(1.0), d0, d1, d2);
                        }
                        for (i = 0; i < 5; ++i) {
                            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), this.func_226282_d_(1.0), this.func_226279_cv_() + 1.0, this.func_226287_g_(1.0), 0.18, 0.3, 0.03);
                        }
                        break;
                    }
                    case "burrow_position": {
                        BlockPos pos = this.func_226268_ag_();
                        this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.func_213339_cH()), (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.05 * Math.random(), 0.0);
                        SoundType soundType = this.func_213339_cH().func_215695_r();
                        this.field_70170_p.func_184148_a(ManaAndArtifice.instance.proxy.getClientPlayer(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185845_c(), SoundCategory.HOSTILE, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                        break;
                    }
                    case "burrow_attack": {
                        BlockPos pos = this.func_226268_ag_();
                        this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.func_213339_cH()), (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.05 * Math.random(), 0.0);
                    }
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isActing = false;
            if (this.isSkyAttacking) {
                this.skyAttackCooldown = 300;
                this.isSkyAttacking = false;
            } else if (this.isBurrowing) {
                this.burrowCooldown = 300;
                this.isBurrowing = false;
            } else if (this.isHealing) {
                this.healCooldown = 1200;
                this.isHealing = false;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void executeInstruction(CustomInstructionKeyframeEvent<EntityMushroomSoldier> event) {
        if (event.instructions == INSTRUCTION_FLING && this.attackEntity == ManaAndArtifice.instance.proxy.getClientPlayer()) {
            this.attackEntity.func_70024_g(0.0, 1.0, 0.0);
        }
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isActing);
        nbt.func_74757_a("sky_attacking", this.isSkyAttacking);
        nbt.func_74757_a("burrowing", this.isBurrowing);
        nbt.func_74757_a("healing", this.isHealing);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isActing = nbt.func_74767_n("attacking");
        this.isSkyAttacking = nbt.func_74767_n("sky_attacking");
        this.isBurrowing = nbt.func_74767_n("burrowing");
        this.isHealing = nbt.func_74767_n("healing");
        if (this.field_70170_p.field_72995_K) {
            if (this.isHealing) {
                DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_HEAL, 18, (LivingEntity)this, this::handleDelayCallback));
            } else if (this.isBurrowing) {
                DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BURROW_POS, 10, (LivingEntity)this, this::handleDelayCallback));
                DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BURROW_FLING, 39, (LivingEntity)this, this::handleDelayCallback));
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.tier = additionalData.readInt();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.tier);
    }

    public class BurrowGoal
    extends Goal {
        public BurrowGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityMushroomSoldier.this.burrowCooldown <= 0 && EntityMushroomSoldier.this.func_233570_aj_() && EntityMushroomSoldier.this.field_70170_p.func_234929_a_(EntityMushroomSoldier.this.func_233580_cy_().func_177977_b(), (Entity)EntityMushroomSoldier.this, Direction.UP) && EntityMushroomSoldier.this.func_70638_az() != null && EntityMushroomSoldier.this.func_70638_az().func_233570_aj_() && EntityMushroomSoldier.this.func_70638_az().func_70032_d((Entity)EntityMushroomSoldier.this) > 8.0f && !EntityMushroomSoldier.this.isActing;
        }

        public void func_75249_e() {
            EntityMushroomSoldier.this.func_70661_as().func_75499_g();
            EntityMushroomSoldier.this.isBurrowing = true;
            EntityMushroomSoldier.this.isActing = true;
            DelayedEventQueue.pushEvent(EntityMushroomSoldier.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityMushroomSoldier.INSTRUCTION_BURROW_POS, 30, EntityMushroomSoldier.this.func_70638_az(), (x$0, x$1) -> EntityMushroomSoldier.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityMushroomSoldier.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityMushroomSoldier.INSTRUCTION_BURROW_FLING, 40, EntityMushroomSoldier.this.func_70638_az(), (x$0, x$1) -> EntityMushroomSoldier.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityMushroomSoldier.this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 47, "", (x$0, x$1) -> EntityMushroomSoldier.this.handleDelayCallback(x$0, x$1)));
            ServerMessageDispatcher.sendEntityStateMessage(EntityMushroomSoldier.this);
        }

        public boolean func_75253_b() {
            return EntityMushroomSoldier.this.isBurrowing;
        }
    }

    public class HealGoal
    extends Goal {
        public HealGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityMushroomSoldier.this.healCooldown <= 0 && EntityMushroomSoldier.this.func_110143_aJ() < EntityMushroomSoldier.this.func_110138_aP() * 0.75f && !EntityMushroomSoldier.this.isActing;
        }

        public void func_75249_e() {
            EntityMushroomSoldier.this.func_70661_as().func_75499_g();
            EntityMushroomSoldier.this.isHealing = true;
            EntityMushroomSoldier.this.isActing = true;
            DelayedEventQueue.pushEvent(EntityMushroomSoldier.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityMushroomSoldier.INSTRUCTION_HEAL, 18, (LivingEntity)EntityMushroomSoldier.this, (x$0, x$1) -> EntityMushroomSoldier.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityMushroomSoldier.this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", (x$0, x$1) -> EntityMushroomSoldier.this.handleDelayCallback(x$0, x$1)));
            ServerMessageDispatcher.sendEntityStateMessage(EntityMushroomSoldier.this);
        }

        public boolean func_75253_b() {
            return EntityMushroomSoldier.this.isHealing;
        }
    }
}

