/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;

public class ConstructCrush
extends ConstructCommand {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[0];
    private int interactTimer = 20;
    private BlockPos interactPos = null;
    private ItemStack requiredItem = ItemStack.field_190927_a;
    private ItemStack output = ItemStack.field_190927_a;

    public ConstructCrush(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.interactPos == null || !this.construct.field_70170_p.func_195588_v(this.interactPos)) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.craft_missing", new Object[0]), false);
            return false;
        }
        return true;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        this.moveBlockTarget = this.interactPos;
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else {
                ItemStack output = this.performCrush();
                if (!output.func_190926_b()) {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.craft_success", new Object[0]), true);
                    this.insertOrDropItem(output);
                } else {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.craft_failed", new Object[0]), true);
                }
                this.interactTimer = 20;
                this.construct.func_184609_a(Math.random() < 0.5 ? Hand.MAIN_HAND : Hand.OFF_HAND);
                this.isFinished = true;
            }
        }
    }

    private ItemStack performCrush() {
        if (this.output.func_190926_b() || this.requiredItem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.construct.field_70170_p.func_195588_v(this.interactPos)) {
            return ItemStack.field_190927_a;
        }
        BlockState state = this.construct.field_70170_p.func_180495_p(this.interactPos);
        if (state == null || state.func_177230_c() != Blocks.field_222427_lP) {
            return ItemStack.field_190927_a;
        }
        Hand[] carrying = this.construct.getCarryingHands();
        boolean consumed = false;
        for (int i = 0; i < carrying.length; ++i) {
            ItemStack stack = this.construct.func_184586_b(carrying[i]);
            if (stack.func_190926_b() || !stack.func_185136_b(this.requiredItem)) continue;
            stack.func_190918_g(1);
            this.construct.func_184611_a(carrying[i], stack);
            consumed = true;
            break;
        }
        if (!consumed) {
            return ItemStack.field_190927_a;
        }
        return this.output.func_77946_l();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = 20;
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.CRUSH;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(3);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructCrush) {
            this.interactPos = ((ConstructCrush)other).interactPos;
            this.output = ((ConstructCrush)other).output.func_77946_l();
            this.requiredItem = ((ConstructCrush)other).requiredItem.func_77946_l();
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack marker = config.func_70301_a(0);
        if (!marker.func_190926_b() && marker.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            this.interactPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(marker);
        }
        this.requiredItem = config.func_70301_a(2).func_77946_l();
        this.output = config.func_70301_a(2).func_77946_l();
    }

    @Override
    public boolean isFullyConfigured() {
        return this.interactPos != null && !this.output.func_190926_b() && !this.requiredItem.func_190926_b();
    }
}

