/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.sorcery;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.IDontCreateBlockItem;
import com.ma.blocks.tileentities.MagelightTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagelightBlock
extends WaterloggableBlock
implements IDontCreateBlockItem {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public MagelightBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f).func_226896_b_().func_200942_a().func_235838_a_(state -> 15).func_222380_e(), false);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MagelightTile();
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity) {
        return PathNodeType.OPEN;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        if (!world.func_195588_v(pos)) {
            return true;
        }
        for (int i = 0; i < 50; ++i) {
            world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, -0.25 + Math.random() * 0.5, Math.random() * 0.25, -0.25 + Math.random() * 0.5);
        }
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (!world.func_201670_d()) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() instanceof DyeItem) {
                this.setLightColor(world, pos, ((DyeItem)heldItem.func_77973_b()).func_195962_g());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void setLightColor(World world, BlockPos pos, DyeColor color) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof MagelightTile) {
            MagelightTile tile = (MagelightTile)te;
            tile.setColor(color.getColorValue());
        }
    }
}

