/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.sorcery;

import com.ma.api.particles.ParticleInit;
import com.ma.blocks.interfaces.ITranslucentBlock;
import com.ma.blocks.tileentities.IllusionBlockTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class IllusionBlock
extends Block
implements ITranslucentBlock {
    private static final BooleanProperty DISABLE_ILLUSION = BooleanProperty.func_177716_a((String)"disable_illusion");

    public IllusionBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)DISABLE_ILLUSION, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, DISABLE_ILLUSION});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face = context.func_196000_l().func_176734_d();
        if (context.func_195999_j().func_213453_ef()) {
            face = face.func_176734_d();
        }
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)face);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new IllusionBlockTile();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        if (((Boolean)state.func_177229_b((Property)DISABLE_ILLUSION)).booleanValue()) {
            return BlockRenderType.MODEL;
        }
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        for (int i = 0; i < 20; ++i) {
            world.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_VELOCITY.get(), (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.05 * Math.random(), 0.0);
        }
        return true;
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return false;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof LivingEntity && !(context.getEntity() instanceof PlayerEntity)) {
            return VoxelShapes.func_197868_b();
        }
        return VoxelShapes.func_197880_a();
    }
}

