/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.artifice;

import com.ma.api.items.MAItemGroups;
import com.ma.blocks.ICustomCategory;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.ICutoutBlock;
import com.ma.blocks.tileentities.ArcaneSentryTile;
import java.util.function.Consumer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class ArcaneSentryBlock
extends WaterloggableBlock
implements ICutoutBlock,
ICustomCategory {
    public static final BooleanProperty SHOOTING = BooleanProperty.func_177716_a((String)"shooting");

    public ArcaneSentryBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_226896_b_().harvestLevel(3).harvestTool(ToolType.PICKAXE).func_200948_a(6.0f, 30.0f).func_200942_a(), false);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)SHOOTING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ArcaneSentryTile && placer instanceof PlayerEntity) {
            ArcaneSentryTile teas = (ArcaneSentryTile)te;
            teas.setOwner((PlayerEntity)placer);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SHOOTING});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ArcaneSentryTile teas;
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ArcaneSentryTile && ((teas = (ArcaneSentryTile)te).getOwner() == player || teas.getOwnerTeam() != null && teas.getOwnerTeam().func_142054_a(player.func_96124_cp()))) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((ArcaneSentryTile)te), (Consumer)((ArcaneSentryTile)te));
        }
        return ActionResultType.SUCCESS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ArcaneSentryTile();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropInventory(worldIn, pos);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ArcaneSentryTile) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ArcaneSentryTile && ((ArcaneSentryTile)te).hasTarget()) {
            return 15;
        }
        return 0;
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.artifice;
    }
}

