/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.Utils;

public class ChronalExchangeMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    private int tickCounter = 0;
    private long dayCounter = 0L;
    private static final String DAY_COUNTER_TAG = "MAHOUTSUKAI_DAY_COUNTER_TAG";

    public ChronalExchangeMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.chronalExchange);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCounter == MTConfig.CHRONAL_EXCHANGE_BLOCK_CYCLE) {
                this.doManaGenOrLoss();
                this.tickCounter = 0;
            }
            ++this.tickCounter;
            ++this.dayCounter;
            this.dayCounter %= 24000L;
            if (this.dayCounter < 0L) {
                this.dayCounter += 24000L;
            }
        }
    }

    public void setTime(long t) {
        this.dayCounter = t;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74772_a(DAY_COUNTER_TAG, this.dayCounter);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.dayCounter = compound.func_74763_f(DAY_COUNTER_TAG);
        super.func_230337_a_(state, compound);
    }

    public void doManaGenOrLoss() {
        IMahou mahou;
        PlayerEntity player = this.getCaster();
        if (player != null && this.field_145850_b != null && (mahou = Utils.getPlayerMahou(player)) != null) {
            int restore = this.calculateMana();
            if (restore < 0) {
                PlayerManaManager.drainMana(player, -restore, false, false, false, true);
            } else {
                int storedMana = mahou.getStoredMana();
                mahou.setStoredMana(Math.min(storedMana + restore, mahou.getMaxMana()));
            }
        }
    }

    public int calculateMana() {
        return this.getManaFromTime(this.field_145850_b.func_72820_D());
    }

    public int getManaFromTime(long t) {
        float distance;
        float smaller = -MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS;
        float diff = 2 * MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS;
        long now = t % 24000L;
        if (now < 0L) {
            now += 24000L;
        }
        if ((distance = (float)(this.dayCounter % 24000L)) < 0.0f) {
            distance += 24000.0f;
        }
        float ratio = Math.abs(distance - 12000.0f) / 12000.0f;
        int ret = (int)(smaller + diff * ratio);
        return ret;
    }

    public boolean timeInRange(long x, long y) {
        return x < y + 6000L && x >= y - 6000L;
    }
}

