/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class DisplacementBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    private static final boolean livingOnly = true;

    public DisplacementBoundaryMahoujinTileEntity() {
        super(ModTileEntities.displacementBoundary, true);
    }

    @Override
    public int getManaCost() {
        return MTConfig.DISPLACEMENT_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.DISPLACEMENT_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.DISPLACEMENT_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.DISPLACEMENT_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        double x1 = this.field_174879_c.func_177958_n() - this.getBarrierRadius() + 1;
        double x2 = this.field_174879_c.func_177958_n() + this.getBarrierRadius() - 1;
        double z1 = this.field_174879_c.func_177952_p() - this.getBarrierRadius() + 1;
        double z2 = this.field_174879_c.func_177952_p() + this.getBarrierRadius() - 1;
        PlayerEntity caster = this.getCaster();
        for (Entity entity : entities) {
            if (ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), entity)) continue;
            double x = entity.func_226277_ct_();
            double y = entity.func_226278_cu_();
            double z = entity.func_226281_cx_();
            Vector3d lv = entity.func_70040_Z();
            double lx = lv.field_72450_a;
            double lz = lv.field_72449_c;
            BlockPos newPos = this.getDestination(this, x, y, z, lx, lz);
            BlockPos oldPos = new BlockPos(x, y, z);
            boolean doSwitch = !((double)oldPos.func_177958_n() > x1 && (double)oldPos.func_177958_n() < x2 && (double)oldPos.func_177952_p() > z1 && (double)oldPos.func_177952_p() < z2);
            if (!doSwitch) continue;
            BlockPos ascendedPos = this.getAscendedDestination(newPos, this.field_145850_b, entity);
            if (ascendedPos != null) {
                newPos = ascendedPos;
            }
            if (this.field_145850_b.field_72995_K) continue;
            if (entity instanceof ServerPlayerEntity && !((ServerPlayerEntity)entity).func_175149_v() && !((ServerPlayerEntity)entity).func_184812_l_()) {
                ((ServerPlayerEntity)entity).field_71135_a.func_147364_a((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
                continue;
            }
            entity.func_70634_a((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
        }
    }

    public BlockPos getDestination(DisplacementBoundaryMahoujinTileEntity te, double x, double y, double z, double lx, double lz) {
        double nz;
        BlockPos ret = null;
        double nx = x;
        double ny = y;
        if (te != null) {
            double x1 = te.func_174877_v().func_177958_n() - this.getBarrierRadius();
            double x2 = x1 + (double)(this.getBarrierRadius() * 2);
            double z1 = te.func_174877_v().func_177952_p() - this.getBarrierRadius();
            double z2 = z1 + (double)(this.getBarrierRadius() * 2);
            for (nz = z; nx > x1 && nx < x2 && nz > z1 && nz < z2; nx += lx, nz += lz) {
            }
        }
        ret = new BlockPos(nx, ny, nz);
        return ret;
    }

    public BlockPos getAscendedDestination(BlockPos p, World w, Entity e) {
        BlockPos tmp = p;
        while (tmp.func_177956_o() < w.func_217301_I()) {
            if (this.okPosition(tmp, w, e)) {
                return tmp;
            }
            tmp = tmp.func_177984_a();
        }
        return null;
    }

    public boolean okPosition(BlockPos p, World w, Entity e) {
        int i = 0;
        while ((float)i < e.func_213302_cg()) {
            BlockPos tmp = p.func_177982_a(0, i, 0);
            if (!Utils.isBlockAir(this.field_145850_b, tmp)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((IItemProvider)ModItems.boundaryDisplacementScroll);
    }
}

