/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class AlarmBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public boolean detected = false;
    public String alarmName = null;

    public AlarmBoundaryMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.alarmBoundary);
    }

    @Override
    public int getManaCost() {
        return MTConfig.ALARM_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.ALARM_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.ALARM_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.ALARM_BARRIER_RADIUS;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.getAlarmName() != null) {
            compound.func_74778_a("alarm_name", this.alarmName);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("alarm_name")) {
            this.alarmName = compound.func_74779_i("alarm_name");
        }
        super.func_230337_a_(state, compound);
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        PlayerEntity caster = this.getCaster();
        this.detected = false;
        if (this.entitiesInBarrier != null && caster != null) {
            for (LivingEntity e : entities) {
                if (!ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)e)) {
                    this.detected = true;
                }
                if (this.entitiesInBarrier.contains(e.func_110124_au())) continue;
                this.soundAlarm(e, caster);
            }
        }
        this.setNewName();
        this.sendUpdates();
    }

    public void setNewName() {
        Entity entityIn;
        List lst = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
        if (!lst.isEmpty() && (entityIn = (Entity)lst.get(0)) instanceof ItemEntity && ((ItemEntity)entityIn).func_92059_d().func_77973_b() == Items.field_151057_cb && ((ItemEntity)entityIn).func_200214_m() != null && ((ItemEntity)entityIn).func_200214_m().equals(this.getCasterUUID())) {
            String s;
            this.alarmName = s = ((ItemEntity)entityIn).func_92059_d().func_200301_q().getString();
        }
    }

    public void soundAlarm(LivingEntity entityIn, PlayerEntity caster) {
        if (caster != null) {
            if (entityIn instanceof PlayerEntity && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)entityIn)) {
                caster.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + this.getAlarmName() + ": " + entityIn.func_145748_c_().getString() + " has entered your boundary."), MTConfig.ALARM_ACTION_BAR_MESSAGES);
            } else if (!ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)entityIn)) {
                caster.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + this.getAlarmName() + ": " + entityIn.func_145748_c_().getString() + " has entered your boundary."), MTConfig.ALARM_ACTION_BAR_MESSAGES);
            }
        }
    }

    @Override
    public void doNotBarrier() {
        if (this.detected) {
            this.detected = false;
            this.sendUpdates();
        }
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((IItemProvider)ModItems.boundaryAlarmScroll);
    }
}

