/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.shader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.system.MemoryUtil;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.FogRenderLayer;
import stepsword.mahoutsukai.render.shader.FogShader;
import stepsword.mahoutsukai.render.shader.ShaderCallback;

public final class ShaderHelper {
    public static final FloatBuffer FLOAT_BUF = MemoryUtil.memAllocFloat((int)1);
    private static final Map<MahouShaders, ShaderProgram> PROGRAMS = new EnumMap<MahouShaders, ShaderProgram>(MahouShaders.class);
    private static boolean hasIncompatibleMods = false;
    private static boolean checkedIncompatibility = false;

    public static void initShaders() {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)manager -> {
                OptionalInt prog;
                PROGRAMS.values().forEach(ShaderLinkHelper::func_148077_a);
                PROGRAMS.clear();
                ShaderHelper.loadShaders(manager);
                if (FogRenderLayer.FOG_SHADER == null && (prog = ShaderHelper.getShader(MahouShaders.FOG)).isPresent()) {
                    int p = prog.getAsInt();
                    FogRenderLayer.FOG_SHADER = new FogShader(p);
                }
            }));
        }
    }

    private static void loadShaders(IResourceManager manager) {
        if (!ShaderHelper.useShaders()) {
            System.out.println("Mahou Shaders disabled");
            return;
        }
        for (MahouShaders shader : MahouShaders.values()) {
            ShaderHelper.createProgram(manager, shader);
        }
    }

    public static OptionalInt getShader(MahouShaders shader) {
        ShaderProgram prog = PROGRAMS.get((Object)shader);
        return prog == null ? OptionalInt.empty() : OptionalInt.of(prog.func_147986_h());
    }

    public static void useShader(MahouShaders shader, ShaderCallback callback) {
        ShaderProgram prog = PROGRAMS.get((Object)shader);
        if (prog == null) {
            return;
        }
        ShaderHelper.useShader(prog.func_147986_h(), callback);
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        ShaderLinkHelper.func_227804_a_((int)shader);
        if (callback != null) {
            callback.call(shader);
        }
    }

    public static void useShader(MahouShaders shader) {
        if (ShaderHelper.useShaders()) {
            ShaderHelper.useShader(shader, null);
        }
    }

    public static void releaseShader() {
        if (ShaderHelper.useShaders()) {
            ShaderLinkHelper.func_227804_a_((int)0);
        }
    }

    public static boolean useShaders() {
        return ShaderHelper.checkIncompatibleMods();
    }

    private static boolean checkIncompatibleMods() {
        if (!checkedIncompatibility) {
            hasIncompatibleMods = ShaderHelper.shadersOn();
            checkedIncompatibility = true;
        }
        return !hasIncompatibleMods && !MTConfig.NO_SHADERS;
    }

    public static boolean shadersOn() {
        String shaders = "net.optifine.shaders.Shaders";
        String config = "net.optifine.Config";
        if (ShaderHelper.isClass(config)) {
            System.err.println("config found");
            try {
                Method isShadersMethod = Class.forName(config).getMethod("isShaders", new Class[0]);
                Boolean isShaders = (Boolean)isShadersMethod.invoke(null, new Object[0]);
                if (isShaders.booleanValue()) {
                    return true;
                }
                System.err.println("not isShaders");
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        } else {
            if (ShaderHelper.isClass(config)) {
                System.err.println("no config");
            }
            if (ShaderHelper.isClass(shaders)) {
                System.err.println("no shaders");
            }
        }
        return false;
    }

    public static boolean isClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void createProgram(IResourceManager manager, MahouShaders shader) {
        try {
            ShaderLoader vert = ShaderHelper.createShader(manager, shader.vertexShaderPath, ShaderLoader.ShaderType.VERTEX);
            ShaderLoader frag = ShaderHelper.createShader(manager, shader.fragmentShaderPath, ShaderLoader.ShaderType.FRAGMENT);
            int progId = ShaderLinkHelper.func_148078_c();
            ShaderProgram prog = new ShaderProgram(progId, vert, frag);
            ShaderLinkHelper.func_148075_b((IShaderManager)prog);
            PROGRAMS.put(shader, prog);
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
    }

    private static ShaderLoader createShader(IResourceManager manager, String filename, ShaderLoader.ShaderType shaderType) throws IOException {
        ResourceLocation loc = new ResourceLocation("mahoutsukai", filename);
        try (BufferedInputStream is = new BufferedInputStream(manager.func_199002_a(loc).func_199027_b());){
            ShaderLoader shaderLoader = ShaderLoader.func_216534_a((ShaderLoader.ShaderType)shaderType, (String)loc.toString(), (InputStream)is, (String)shaderType.func_148062_a());
            return shaderLoader;
        }
    }

    private static class ShaderProgram
    implements IShaderManager {
        private final int program;
        private final ShaderLoader vert;
        private final ShaderLoader frag;

        private ShaderProgram(int program, ShaderLoader vert, ShaderLoader frag) {
            this.program = program;
            this.vert = vert;
            this.frag = frag;
        }

        public int func_147986_h() {
            return this.program;
        }

        public void func_147985_d() {
        }

        public ShaderLoader func_147989_e() {
            return this.vert;
        }

        public ShaderLoader func_147994_f() {
            return this.frag;
        }
    }

    public static enum MahouShaders {
        FOG("shaders/fog.vert", "shaders/fog.frag");

        public final String vertexShaderPath;
        public final String fragmentShaderPath;

        private MahouShaders(String vertexShaderPath, String fragmentShaderPath) {
            this.vertexShaderPath = vertexShaderPath;
            this.fragmentShaderPath = fragmentShaderPath;
        }
    }
}

