/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.exchange.ImmunityExchangeSpellScroll;
import stepsword.mahoutsukai.item.spells.familiar.PossessEntitySpellScroll;
import stepsword.mahoutsukai.item.spells.mystic.DamageReplicationSpellScroll;
import stepsword.mahoutsukai.item.spells.projection.ProjectionSpellScroll;
import stepsword.mahoutsukai.item.spells.projection.ProximityProjection.ProximityProjectionKeys;
import stepsword.mahoutsukai.item.spells.projection.RealityMarbleSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.GeasSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.RetributionSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.NoDepthWrappedRenderLayer;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderSelectedEntity {
    static ResourceLocation loc = new ResourceLocation("mahoutsukai", "textures/particle/white_magic_particle1.png");
    public static Entity currentSelected = null;
    public static Entity secondSelected = null;
    public static long selectionKeyPress = 0L;

    public static void selectedEntity(Entity camera) {
        if (camera instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)camera;
            HashSet<Utils.MAHOU_SELECTION> set = RenderSelectedEntity.shouldRenderSelected(player);
            if (set.size() > 0) {
                if (set.contains((Object)Utils.MAHOU_SELECTION.SELECTIVE_DISPLACEMENT) && Keybinds.selectiveDisplacement.func_151470_d()) {
                    ++selectionKeyPress;
                    if (currentSelected == null) {
                        currentSelected = Utils.selectEntityNearCursor(player, RenderSelectedEntity.getDistance(set), player.field_70170_p, a -> Utils.getPredicate(set, a, player), Utils.nearAllowed(set));
                    } else if (selectionKeyPress > (long)MTConfig.SELECTIVE_DISPLACEMENT_HOLD_TIME) {
                        secondSelected = Utils.selectEntityNearCursor(player, RenderSelectedEntity.getDistance(set), player.field_70170_p, a -> Utils.getPredicate(set, a, player), Utils.nearAllowed(set));
                    }
                } else {
                    currentSelected = Utils.selectEntityNearCursor(player, RenderSelectedEntity.getDistance(set), player.field_70170_p, a -> Utils.getPredicate(set, a, player), Utils.nearAllowed(set));
                }
            } else {
                currentSelected = null;
                secondSelected = null;
            }
        }
    }

    public static void renderSelectedEntity(RenderWorldLastEvent event) {
        MatrixStack matrix = event.getMatrixStack();
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        float partialTicks = event.getPartialTicks();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        if (MTConfig.SHOW_SELECTED_ENTITY && camera instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)camera;
            if (currentSelected != null && !currentSelected.func_98034_c(player)) {
                RenderSelectedEntity.renderSelection(matrix, buffer, partialTicks, currentSelected, player);
            }
            if (secondSelected != null && !secondSelected.func_98034_c(player)) {
                RenderSelectedEntity.renderSelection(matrix, buffer, partialTicks, secondSelected, player);
            }
        }
    }

    public static void renderSelection(MatrixStack matrix, IRenderTypeBuffer.Impl buffer, float partialTicks, Entity e, PlayerEntity player) {
        Vector3d proj = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double d3 = proj.field_72450_a;
        double d4 = proj.field_72448_b;
        double d5 = proj.field_72449_c;
        Vector3d center = e.func_174813_aQ().func_189972_c();
        Vector3d diff = center.func_178788_d(e.func_213303_ch());
        Vector3d prev = new Vector3d(e.field_70169_q, e.field_70167_r, e.field_70166_s);
        prev = prev.func_178787_e(diff);
        double d0 = prev.field_72450_a + (center.field_72450_a - prev.field_72450_a) * (double)partialTicks;
        double d1 = prev.field_72448_b + (center.field_72448_b - prev.field_72448_b) * (double)partialTicks;
        double d2 = prev.field_72449_c + (center.field_72449_c - prev.field_72449_c) * (double)partialTicks;
        matrix.func_227860_a_();
        matrix.func_227861_a_(d0 - d3, d1 - d4, d2 - d5);
        if (player != null) {
            float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks;
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            RenderUtils.rotateQ(360.0f - yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, matrix);
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            int space = 20;
            int separators = 4;
            int degrees = 360 / separators;
            RenderUtils.rotateQ(player.field_70170_p.func_82737_E() % 360L * 2L, 0.0f, 1.0f, 0.0f, matrix);
            for (int i = 1; i < separators + 1; ++i) {
                RenderUtils.rotateQ(degrees, 0.0f, 1.0f, 0.0f, matrix);
                NoDepthWrappedRenderLayer type = new NoDepthWrappedRenderLayer(new CullWrappedRenderLayer(MahoujinRenderType.createRunesNoDepthRenderType(RenderUtils.beam, RenderUtils.rune_index++)));
                RenderSelectedEntity.renderArc(matrix, buffer, 0.0, 0.0f, 1.0f, 0.12f, 128, 240, 240, 1.0f, 1.0f, 1.0f, 1.0f, type, degrees - space, 0.0f);
                type = new NoDepthWrappedRenderLayer(new CullWrappedRenderLayer(MahoujinRenderType.createRunesNoDepthRenderType(RenderUtils.beam, RenderUtils.rune_index++)));
                RenderSelectedEntity.renderArc(matrix, buffer, 0.0, 0.0f, 1.0f, 0.16f, 128, 240, 240, 1.0f, 0.8f, 0.7f, 0.6f, type, degrees - space, 0.0f);
            }
        }
        matrix.func_227865_b_();
    }

    public static HashSet<Utils.MAHOU_SELECTION> shouldRenderSelected(PlayerEntity player) {
        int slot;
        IItemHandler inventory;
        ItemStack mainhand = player.func_184614_ca();
        Item item = mainhand.func_77973_b();
        Item item2 = player.func_184592_cb().func_77973_b();
        Item item3 = null;
        if (mainhand.func_77973_b() instanceof MysticCode && (inventory = Utils.getMCInventory(mainhand)) != null && (slot = MysticCode.getSlot(mainhand)) >= 0 && slot < 3) {
            ItemStack ammo = inventory.getStackInSlot(slot);
            item3 = ammo.func_77973_b();
        }
        HashSet<Utils.MAHOU_SELECTION> set = RenderSelectedEntity.shouldRenderSelected(player, item);
        set.addAll(RenderSelectedEntity.shouldRenderSelected(player, item2));
        set.addAll(RenderSelectedEntity.shouldRenderSelected(player, item3));
        return set;
    }

    public static HashSet<Utils.MAHOU_SELECTION> shouldRenderSelected(PlayerEntity player, Item item) {
        HashSet<Utils.MAHOU_SELECTION> set = new HashSet<Utils.MAHOU_SELECTION>();
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT) && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN)) {
            set.add(Utils.MAHOU_SELECTION.SELECTIVE_DISPLACEMENT);
        }
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.INSIGHT)) {
            set.add(Utils.MAHOU_SELECTION.INSIGHT);
        }
        if (item instanceof ProjectionSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_PROJECTION);
        }
        if (item instanceof RetributionSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_RETRIBUTION);
        }
        if (item instanceof ImmunityExchangeSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_IMMUNITY_EXCHANGE);
        }
        if (item instanceof PossessEntitySpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_POSSESS_ENTITY);
        }
        if (item instanceof DamageReplicationSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_DAMAGE_REPLICATION);
        }
        if (item instanceof GeasSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_GEAS);
        }
        if (item instanceof RealityMarbleSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_REALITY_MARBLE);
        }
        if (item instanceof TheRipper) {
            set.add(Utils.MAHOU_SELECTION.RIPPER_FOG);
        }
        if (item instanceof ProximityProjectionKeys) {
            set.add(Utils.MAHOU_SELECTION.WEAPON);
        }
        return set;
    }

    public static int getDistance(HashSet<Utils.MAHOU_SELECTION> set) {
        if (set.contains((Object)Utils.MAHOU_SELECTION.SELECTIVE_DISPLACEMENT)) {
            return MTConfig.SELECTIVE_DISPLACEMENT_RANGE;
        }
        return MTConfig.GLOBAL_LOOK_RANGE;
    }

    public static RenderType renderArc(MatrixStack matrix, IRenderTypeBuffer.Impl buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float arcfinish, float anglestart) {
        matrix.func_227860_a_();
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        IVertexBuilder bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double stop = EffectUtil.toRad(arcfinish);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float circle_b = 0.0f;
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
                bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            circle_b = (float)((Math.sin(Math.toRadians((theta * (double)i + (double)anglestart) % 360.0)) + 1.0) / 2.0);
            circle_b = 1.0f;
            bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, circle_b, a).func_225583_a_(texx, 0.0f).func_225587_b_(lx, ly).func_181675_d();
            bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, circle_b, a).func_225583_a_(texx, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            if (tt > stop) break;
        }
        buffer.func_228462_a_(type);
        matrix.func_227865_b_();
        return type;
    }
}

