/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.eventbus.api.Event;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.fluids.MurkyWater;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.render.overlay.RenderFogProjectors;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderPowerConsolidation {
    public static float distanceToMurkyWater(Entity entity) {
        int r = (int)MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
        BlockPos minPos = entity.func_233580_cy_().func_177982_a(-r, -r, -r);
        BlockPos maxPos = entity.func_233580_cy_().func_177982_a(r, r, r);
        ChunkPos minCPos = new ChunkPos(minPos);
        ChunkPos maxCPos = new ChunkPos(maxPos);
        float ret = -1.0f;
        try {
            for (int x = minCPos.field_77276_a; x < maxCPos.field_77276_a + 1; ++x) {
                for (int z = minCPos.field_77275_b; z < maxCPos.field_77275_b + 1; ++z) {
                    IChunkMahou chunkMahou;
                    ConcurrentSet<BlockPos> blocks;
                    Chunk c = entity.field_70170_p.func_212866_a_(x, z);
                    if (!(c instanceof Chunk) || (blocks = (chunkMahou = Utils.getChunkMahou(c)).getLakeBlocks()) == null || blocks.size() <= 0) continue;
                    for (BlockPos p : blocks) {
                        Block b = entity.field_70170_p.func_180495_p(p).func_177230_c();
                        if (b != ModBlocks.murkyFluid || Math.abs(p.func_177958_n() - entity.func_233580_cy_().func_177958_n()) >= r || Math.abs(p.func_177952_p() - entity.func_233580_cy_().func_177952_p()) >= r || Math.abs(p.func_177956_o() - entity.func_233580_cy_().func_177956_o()) >= r) continue;
                        float d = (float)entity.func_213303_ch().func_72438_d(EffectUtil.fromBlockPos(p).func_72441_c(0.5, 0.5, 0.5));
                        if (ret == -1.0f) {
                            ret = d;
                        }
                        if (!(ret > d)) continue;
                        ret = d;
                    }
                }
            }
        }
        catch (Exception e) {
            return -1.0f;
        }
        return ret;
    }

    public static boolean powerConsolidationFogColor(EntityViewRenderEvent.FogColors event) {
        boolean ret = false;
        double d = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.func_71410_x().func_175606_aa());
        if (Utils.isInMurkyWater(Minecraft.func_71410_x().func_175606_aa())) {
            event.setRed(0.0f);
            event.setGreen(0.15686275f);
            event.setBlue(0.0f);
            ret = true;
        } else if (d <= MTConfig.POWER_CONSOLIDATION_FOG_RADIUS && d >= 0.0) {
            float c = 180.0f;
            float td = 0.0f;
            float tr = 0.0f;
            float tg = 0.0f;
            float tb = 0.0f;
            double colorstrength = (MTConfig.POWER_CONSOLIDATION_FOG_RADIUS - d) / MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
            td = (float)((double)td + (colorstrength *= 2.0));
            tr = (float)((double)tr + (double)c * colorstrength);
            tg = (float)((double)tg + (double)c * colorstrength);
            tb = (float)((double)tb + (double)c * colorstrength);
            float r = (tr += event.getRed() * 255.0f) / (td += 1.0f) / 255.0f;
            float g = (tg += event.getGreen() * 255.0f) / td / 255.0f;
            float b = (tb += event.getBlue() * 255.0f) / td / 255.0f;
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
            ret = true;
        }
        return ret;
    }

    public static boolean powerConsolidationBlockOverlay(RenderBlockOverlayEvent event) {
        return Minecraft.func_71410_x().func_175606_aa() != null && Utils.isInMurkyWater(Minecraft.func_71410_x().func_175606_aa());
    }

    public static boolean powerConsolidationRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        boolean ret = RenderPowerConsolidation.doFog(event.getType(), event.getFarPlaneDistance());
        if (ret) {
            event.setResult(Event.Result.ALLOW);
        }
        return ret;
    }

    public static void powerConsolidationFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (Utils.isInMurkyWater(Minecraft.func_71410_x().func_175606_aa())) {
            event.setDensity(0.5f);
            event.setCanceled(true);
            RenderSystem.fog((int)2918, (float)((float)MurkyWater.COLOR.getRed() / 255.0f), (float)((float)MurkyWater.COLOR.getGreen() / 255.0f), (float)((float)MurkyWater.COLOR.getBlue() / 255.0f), (float)1.0f);
        }
    }

    public static boolean doFog(FogRenderer.FogType type, float farPlane) {
        double f = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.func_71410_x().func_175606_aa());
        double top = MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
        if ((f = Math.min(f, top)) > 0.0) {
            double strength = 50.0 - 50.0 / top * f;
            double f1 = Math.min(strength, (double)FogProjectorScreen.camera_fog_strength_max) / (double)FogProjectorScreen.camera_fog_strength_max;
            float oldstart = type == FogRenderer.FogType.FOG_SKY ? 2.0f : farPlane * 0.75f;
            double f2 = RenderFogProjectors.fogScaleFormula(farPlane, f1);
            double f3 = RenderFogProjectors.fogScaleFormula(oldstart, f1);
            double fogStart = MathHelper.func_151237_a((double)f3, (double)1.0, (double)oldstart);
            double fogEnd = MathHelper.func_151237_a((double)f2, (double)4.0, (double)farPlane);
            if (type == FogRenderer.FogType.FOG_SKY) {
                fogStart = 0.0;
            }
            float fg = 0.7058824f;
            RenderSystem.enableFog();
            RenderSystem.fog((int)2918, (float)fg, (float)fg, (float)fg, (float)1.0f);
            RenderSystem.fogStart((float)((float)fogStart));
            RenderSystem.fogEnd((float)((float)fogEnd));
            return true;
        }
        return false;
    }
}

