/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderGandrEntity
extends EntityRenderer<GandrEntity> {
    public RenderGandrEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(GandrEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(GandrEntity entity, float eyaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
    }

    public static void renderGandr(GandrEntity entity, double x, double y, double z, MatrixStack matrix, float partialTicks) {
        float maxsize = 0.1f;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        float r2 = colors[4];
        float g2 = colors[5];
        float b2 = colors[6];
        matrix.func_227860_a_();
        matrix.func_227861_a_(x, y, z);
        RenderUtils.rotateQ(-entity.field_70177_z, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(entity.field_70125_A, 1.0f, 0.0f, 0.0f, matrix);
        float liferatio = maxsize * (float)entity.getLife() / entity.getGrowingLife();
        float liferatioinv = maxsize;
        liferatio = Math.min(maxsize, liferatio);
        liferatioinv = Math.max(0.0f, liferatioinv);
        CullWrappedRenderLayer sphere1 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 0));
        CullWrappedRenderLayer sphere2 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 1));
        IRenderTypeBuffer.Impl buf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        matrix.func_227862_a_(1.6f, 1.6f, 1.6f);
        if (entity.getFired()) {
            float firedProgress = (float)entity.ticksSinceFired / (float)entity.firedProgressLife;
            firedProgress = Math.min(1.0f, firedProgress);
            matrix.func_227862_a_(1.0f - 0.2f * firedProgress, 1.0f - 0.2f * firedProgress, 1.0f + 0.4f * firedProgress);
        } else {
            double yshake;
            double xshake;
            float ringrot;
            if ((float)entity.getLife() < entity.getGrowingLife()) {
                ringrot = entity.getLife();
                xshake = 0.0;
                yshake = 0.0;
            } else {
                xshake = Math.random() * (double)0.003f - (double)0.0015f;
                yshake = Math.random() * (double)0.003f - (double)0.0015f;
                ringrot = entity.getGrowingLife();
            }
            matrix.func_227860_a_();
            matrix.func_227861_a_(xshake, yshake, (double)-0.15f);
            CullWrappedRenderLayer ring1 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.runes, 7));
            RenderUtils.rotateQ(90.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(ringrot, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 0.0f, 0.2f - 0.001f * ringrot, 0.05f, 64, 240, 240, r, g, b, 1.0f, ring1);
            buf.func_228462_a_((RenderType)ring1);
            matrix.func_227865_b_();
        }
        RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, liferatio * 0.9f, 32, 240, 240, r2, g2, b2, 1.0f, sphere1);
        RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, liferatio * 1.1f, 32, 240, 240, r, g, b, 0.09f, sphere2);
        buf.func_228462_a_((RenderType)sphere1);
        buf.func_228462_a_((RenderType)sphere2);
        long time = ClientHandler.clientTickCounter;
        float repeat = 200.0f;
        float progress = (float)time % repeat / repeat;
        if (entity.inited) {
            float[] progressStarts = entity.progressstarts;
            float[] progressEnds = entity.progressends;
            for (int j = 0; j < entity.swirls; ++j) {
                float thisProgress;
                if (!RenderGandrEntity.progressInRange(progress, progressStarts[j], progressEnds[j])) continue;
                CullWrappedRenderLayer arc1 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, 2));
                CullWrappedRenderLayer arc2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, 3));
                if (progressStarts[j] < progressEnds[j]) {
                    thisProgress = (progress - progressStarts[j]) / (progressEnds[j] - progressStarts[j]);
                } else {
                    float range = progressEnds[j] + 1.0f - progressStarts[j];
                    thisProgress = progress < progressEnds[j] ? (progress + 1.0f - progressStarts[j]) / range : (progress - progressStarts[j]) / range;
                }
                float progressFront = thisProgress + 0.7f;
                float progressBack = thisProgress;
                float angle = entity.angles[j];
                matrix.func_227860_a_();
                if (!entity.getFired()) {
                    RenderUtils.rotateQ(entity.angles[j], 0.0f, 1.0f, 0.0f, matrix);
                    RenderUtils.rotateQ(entity.angles[(j + 1) % entity.swirls], 1.0f, 0.0f, 0.0f, matrix);
                    RenderGandrEntity.renderPartialArcSpiral(matrix, (IRenderTypeBuffer)buf, liferatioinv * 0.2f, 90.0f, liferatioinv * 1.8f, liferatioinv * 0.5f, 64, 240, 240, r, g, b, 0.7f, arc1, progressFront, progressBack, liferatio * 0.9f);
                } else {
                    progressFront = 1.0f - thisProgress * 0.55f;
                    progressBack = 1.0f - thisProgress * 0.55f - 0.1f;
                    RenderUtils.rotateQ(-90.0f, 0.0f, 1.0f, 0.0f, matrix);
                    RenderUtils.rotateQ(entity.angles[j], 1.0f, 0.0f, 0.0f, matrix);
                    RenderGandrEntity.renderPartialArcSpiral(matrix, (IRenderTypeBuffer)buf, liferatioinv * 0.2f, 90.0f, liferatioinv * 1.8f, liferatioinv * 0.5f, 64, 240, 240, r, g, b, 0.5f, arc1, progressFront, progressBack, liferatio * 0.9f);
                    RenderUtils.rotateQ(entity.angles[(j + 1) % entity.swirls], 1.0f, 0.0f, 0.0f, matrix);
                    RenderGandrEntity.renderPartialArcSpiral(matrix, (IRenderTypeBuffer)buf, liferatioinv * 0.2f, 90.0f, liferatioinv * 1.8f, liferatioinv * 0.5f, 64, 240, 240, r, g, b, 0.5f, arc2, progressFront, progressBack, liferatio * 0.9f);
                }
                matrix.func_227865_b_();
                buf.func_228462_a_((RenderType)arc1);
            }
        }
        matrix.func_227865_b_();
    }

    public static boolean progressInRange(float p, float s, float e) {
        if (s < e) {
            return p > s && p < e;
        }
        return p > s || p < e;
    }

    public static RenderType renderPartialArcSpiral(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float pf, float pb, float innerradius) {
        matrix.func_227860_a_();
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        IVertexBuilder bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double h2 = height;
        double r2 = radius;
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double offset = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = 0.0f;
        int i = (int)((float)num_segments * pb);
        while ((float)i < Math.min((float)num_segments * pf + 1.0f, (float)(num_segments + 1))) {
            r2 = innerradius + (radius - innerradius) * ((float)(num_segments - i) / (float)num_segments);
            h2 = height * ((float)(num_segments - i) / (float)num_segments);
            p = r2 + h2 * Math.cos(EffectUtil.toRad(flatness));
            q = h2 * Math.sin(EffectUtil.toRad(flatness));
            offset = ((double)height - q) / 2.0;
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
                bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            }
            double tt = (double)i * theta;
            x = -r2 * Math.sin(tt);
            y = cy - offset;
            z = r2 * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q - offset;
            zb = p * Math.cos(tt);
            bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(texx, 0.0f).func_225587_b_(lx, ly).func_181675_d();
            bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(texx, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            ++i;
        }
        matrix.func_227865_b_();
        return type;
    }
}

