/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownBeamEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderFallenDownBeamEntity
extends EntityRenderer<FallenDownBeamEntity> {
    public RenderFallenDownBeamEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(FallenDownBeamEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(FallenDownBeamEntity entity, float eyaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
    }

    public static void renderFallenDownBeam(FallenDownBeamEntity entity, double x, double y, double z, MatrixStack matrix, float partialTicks) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(x, y, z);
        matrix.func_227861_a_(0.0, 1.5, 0.0);
        float time = (float)ClientHandler.clientTickCounter * 1.3f;
        float ticksToFullSize = entity.getGrowingLife();
        float growth = Math.max(0.0f, Math.min(ticksToFullSize, (float)entity.getLife()));
        growth /= ticksToFullSize;
        float rotleft = time;
        float rotright = -time;
        float timeColor = Math.abs((float)(entity.field_70170_p.func_72820_D() % 24000L) - 6000.0f) / 12000.0f;
        float rad = (float)entity.getCurrentRadius();
        float r1 = 0.19215687f;
        float g1 = 0.3529412f;
        float b1 = 0.7058824f;
        float a1 = 1.0f;
        float r2 = 0.27058825f;
        float g2 = 0.7921569f;
        float b2 = 1.0f;
        float a2 = 1.0f;
        float r = r1 + (r2 - r1) * timeColor;
        float g = g1 + (g2 - g1) * timeColor;
        float b = b1 + (b2 - b1) * timeColor;
        float a = a1 + (a2 - a1) * timeColor;
        r = 0.3f;
        g = 0.8f;
        b = 1.0f;
        a = 1.0f;
        int lightmapX = 240;
        int lightmapY = 240;
        int index = 0;
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false));
        IVertexBuilder bb = buffer.getBuffer((RenderType)type);
        RenderFallenDownBeamEntity.renderPlayerLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderFirstLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderSecondLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderThirdLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderFourthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderFifthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderSixthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderBeam(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth, rad);
        }
        matrix.func_227865_b_();
    }

    public static void renderPlayerLayer(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 0.6, 90.0f, 2.0f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.func_228462_a_(t2);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 1.2, 45.0f, 1.4f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.func_228462_a_(t2);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 1.2, 0.0);
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.func_227862_a_(2.0f, 2.0f, 2.0f);
        IVertexBuilder bb = buffer.getBuffer(type);
        RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
        buffer.func_228462_a_(type);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.func_227861_a_(0.0, 0.0, 0.0);
        int num_circles = 4;
        for (int i = 0; i < num_circles; ++i) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(70.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.func_227861_a_(0.0, 2.0, 0.0);
            matrix.func_227862_a_(1.0f, 1.0f, 1.0f);
            bb = buffer.getBuffer(type);
            RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.func_228462_a_(type);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    public static void renderFirstLayer(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        float prevLevel = 10.0f;
        float threshold = 0.0f;
        float endThreshold = 0.5f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 4.2, 0.0f, newgrowth * 4.0f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.func_228462_a_(t2);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 4.0, 0.0f, newgrowth * 2.0f, 1.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.func_228462_a_(t2);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.func_227861_a_(0.0, 2.0, 0.0);
        int num_circles = 8;
        for (int i = 0; i < num_circles; ++i) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(50.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.func_227861_a_(0.0, 5.0, 0.0);
            IVertexBuilder bb = buffer.getBuffer(type);
            matrix.func_227862_a_(newgrowth * 1.2f, newgrowth * 1.2f, newgrowth * 1.2f);
            if (i % 2 == 0) {
                RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            } else {
                t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 0.0, 45.0f, newgrowth * 0.6f, 0.3f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.func_228462_a_(t2);
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, 0.1, 0.0);
                t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 0.0, 0.0f, newgrowth * 0.3f, 0.1f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.func_228462_a_(t2);
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, 0.2, 0.0);
                t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 0.0, 0.0f, newgrowth * 0.4f, 0.1f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.func_228462_a_(t2);
                matrix.func_227865_b_();
                t2 = RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buffer, 0.0, 45.0f, newgrowth * 0.6f, 0.2f, 32, lightmapX, lightmapY, r, g, b, a, index++, RenderUtils.beam);
                buffer.func_228462_a_(t2);
            }
            buffer.func_228462_a_(type);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    public static void renderSecondLayer(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        float prevLevel = 10.0f;
        float threshold = 0.0f;
        float endThreshold = 0.5f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 10.0, 0.0f, newgrowth * 6.0f, 0.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.func_228462_a_(t2);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 10.0, 0.0f, newgrowth * 4.0f, 1.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.func_228462_a_(t2);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        matrix.func_227861_a_(0.0, (double)(newgrowth * 3.0f), 0.0);
        int num_circles = 6;
        for (int i = 0; i < num_circles; ++i) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(60.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.func_227861_a_(0.0, 9.0, 0.0);
            matrix.func_227862_a_(newgrowth * 4.0f, newgrowth * 4.0f, newgrowth * 4.0f);
            IVertexBuilder bb = buffer.getBuffer(type);
            RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.func_228462_a_(type);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    public static void renderThirdLayer(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float prevLevel = 10.0f;
        float threshold = 0.6f;
        float endThreshold = 0.7f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, prevLevel + 5.0f * newgrowth, 0.0f, 6.0f + newgrowth * 2.0f, newgrowth * 0.8f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, prevLevel + 5.0f * newgrowth, 0.0f, 4.0f, newgrowth * 2.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
    }

    public static void renderFourthLayer(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float prevLevel = 10.0f;
        float threshold = 0.5f;
        float endThreshold = 0.6f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, prevLevel + 2.0f * newgrowth, 0.0f, 2.0f + newgrowth * 2.0f, newgrowth * 2.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 5.0 + 2.5 * (double)newgrowth, 90.0f, 2.0f + newgrowth * 4.0f, newgrowth * 0.6f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
    }

    public static void renderFifthLayer(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float threshold = 0.7f;
        float endThreshold = 0.75f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 15.0f + 3.0f * newgrowth, 90.0f, 8.0f + newgrowth * 6.0f, newgrowth * 1.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 10.0f + 4.0f * newgrowth, 90.0f, 4.0f + newgrowth * 7.0f, newgrowth * 1.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
        if (growth > threshold) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, (double)(15.0f + 3.0f * newgrowth), 0.0);
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            matrix.func_227862_a_(16.0f + newgrowth * 2.0f, 16.0f + newgrowth * 2.0f, 16.0f + newgrowth * 2.0f);
            IVertexBuilder bb = buffer.getBuffer(type);
            RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.func_228462_a_(type);
            matrix.func_227865_b_();
        }
    }

    public static void renderSixthLayer(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float threshold = 0.75f;
        float endThreshold = 0.8f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 10.0f + 3.0f * newgrowth, 0.0f, 8.0f + newgrowth * 8.0f, newgrowth * 3.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 18.0f + 3.0f * newgrowth, 0.0f, 9.0f + newgrowth * 12.0f, newgrowth * 3.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (IRenderTypeBuffer)buffer, 18.0f + 3.0f * newgrowth, 0.0f, 9.0f + newgrowth * 4.5f, newgrowth * 5.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.func_228462_a_(t2);
            matrix.func_227865_b_();
        }
    }

    public static void renderBeam(MatrixStack matrix, float rotright, float rotleft, IRenderTypeBuffer.Impl buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth, float rad) {
        float threshold = 0.75f;
        float cy = 255.0f;
        if (growth > threshold) {
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            CullWrappedRenderLayer beam2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, RenderUtils.rune_index++));
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buffer, (double)cy, 90.0f, rad, 512.0f, 64, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 1.0f, beam2);
            buffer.func_228462_a_((RenderType)beam2);
            matrix.func_227865_b_();
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            CullWrappedRenderLayer beam3 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, RenderUtils.rune_index++));
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buffer, (double)cy, 90.0f, rad + 0.08f, 512.0f, 64, lightmapX, lightmapY, r, g, b, 0.4f, beam3);
            buffer.func_228462_a_((RenderType)beam3);
            matrix.func_227865_b_();
            matrix.func_227860_a_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            CullWrappedRenderLayer beam4 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, RenderUtils.rune_index++));
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buffer, (double)cy, 90.0f, rad - 0.08f, 512.0f, 64, lightmapX, lightmapY, r, g, b, 0.4f, beam4);
            buffer.func_228462_a_((RenderType)beam4);
            matrix.func_227865_b_();
        }
    }

    public static void renderCircle(IVertexBuilder bb, MatrixStack matrix, float r, float g, float b, float a, int lightmapX, int lightmapY) {
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        bb.func_227888_a_(m, -0.5f, 0.0f, -0.5f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, -0.5f, 0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f, 0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f, 0.0f, -0.5f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
    }
}

