/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.ButterflyEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public class RenderButterfly
extends EntityRenderer<ButterflyEntity> {
    private static final ResourceLocation butterfly1 = new ResourceLocation("mahoutsukai:textures/entity/butterfly1.png");
    private static final ResourceLocation butterfly2 = new ResourceLocation("mahoutsukai:textures/entity/butterfly2.png");
    private static final ResourceLocation butterfly3 = new ResourceLocation("mahoutsukai:textures/entity/butterfly3.png");
    private static final ResourceLocation butterfly4 = new ResourceLocation("mahoutsukai:textures/entity/butterfly4.png");
    private static final ResourceLocation butterfly5 = new ResourceLocation("mahoutsukai:textures/entity/butterfly5.png");
    private static final ResourceLocation butterfly6 = new ResourceLocation("mahoutsukai:textures/entity/butterfly6.png");
    private static final ResourceLocation butterfly7 = new ResourceLocation("mahoutsukai:textures/entity/butterfly7.png");

    public RenderButterfly(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(ButterflyEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buf, int packedLightIn) {
        boolean z;
        boolean bl = z = entityIn.getCasterUUID() != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(entityIn.getCasterUUID());
        if (MTConfig.BUTTERFLY_EFFECT_VISIBLE_TO_OTHERS || z) {
            matrix.func_227860_a_();
            float angle = entityIn.prevangle + partialTicks * (entityIn.angle - entityIn.prevangle);
            float size = entityIn.getSize();
            float yaw = this.calcPartialYaw(entityIn.field_70177_z, entityIn.field_70126_B, partialTicks);
            matrix.func_227862_a_(size, size, size);
            RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(entityIn.field_70125_A, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(angle, 0.0f, 0.0f, 1.0f, matrix);
            this.drawWing(entityIn, matrix, 0.0f);
            RenderUtils.rotateQ(180.0f - 2.0f * angle, 0.0f, 0.0f, 1.0f, matrix);
            this.drawWing(entityIn, matrix, 0.0f);
            matrix.func_227865_b_();
        }
    }

    public ResourceLocation getTextureLocation(ButterflyEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    private void drawWing(ButterflyEntity e, MatrixStack matrix, float m) {
        this.drawTexture(m * 0.0f, matrix, 0.0f, 0.0f, 0.0f, 1.0f, butterfly1);
        this.drawTexture(m * 0.001f, matrix, e.colors[0][0] / 255.0f, e.colors[0][1] / 255.0f, e.colors[0][2] / 255.0f, 1.0f, butterfly2);
        this.drawTexture(m * 0.001f, matrix, e.colors[1][0] / 255.0f, e.colors[1][1] / 255.0f, e.colors[1][2] / 255.0f, 1.0f, butterfly3);
        this.drawTexture(m * 0.001f, matrix, e.colors[2][0] / 255.0f, e.colors[2][1] / 255.0f, e.colors[2][2] / 255.0f, 1.0f, butterfly4);
        this.drawTexture(m * 0.001f, matrix, e.colors[3][0] / 255.0f, e.colors[3][1] / 255.0f, e.colors[3][2] / 255.0f, 1.0f, butterfly5);
        this.drawTexture(m * 0.001f, matrix, e.colors[4][0] / 255.0f, e.colors[4][1] / 255.0f, e.colors[4][2] / 255.0f, 1.0f, butterfly6);
        this.drawTexture(m * 0.001f, matrix, e.colors[5][0] / 255.0f, e.colors[5][1] / 255.0f, e.colors[5][2] / 255.0f, 1.0f, butterfly7);
    }

    private void drawTexture(float cy, MatrixStack matrix, float r, float g, float b, float a, ResourceLocation loc) {
        int lightmapX = 240;
        int lightmapY = 240;
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        RenderType type = MahoujinRenderType.createMahoujinRenderType(loc, 0, true);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder bb = buffer.getBuffer(type);
        bb.func_227888_a_(positionMatrix, 0.0f, cy, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(positionMatrix, 0.0f, cy, 1.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(positionMatrix, 1.0f, cy, 1.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(positionMatrix, 1.0f, cy, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        buffer.func_228461_a_();
    }

    public float calcPartialYaw(float yw, float pyw, float partial) {
        if ((yw %= 360.0f) < 0.0f) {
            yw += 360.0f;
        }
        if (yw > 360.0f) {
            yw -= 360.0f;
        }
        if ((pyw %= 360.0f) < 0.0f) {
            pyw += 360.0f;
        }
        if (pyw > 360.0f) {
            pyw -= 360.0f;
        }
        if (yw < pyw) {
            float d2 = pyw - yw;
            float d1 = yw + (360.0f - pyw);
            if (d2 < d1) {
                return partial * d2 + yw;
            }
            return partial * d1 + pyw;
        }
        float d2 = yw - pyw;
        float d1 = pyw + (360.0f - yw);
        if (d2 < d1) {
            return partial * d2 + pyw;
        }
        return partial * d1 + yw;
    }
}

