/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.enchant.MahoujinProjectorEnchant;
import stepsword.mahoutsukai.enchant.ModEnchantments;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class ProjectorRightClickPacket {
    ARMOR_ACTION action;
    BlockPos pos;

    public ProjectorRightClickPacket() {
    }

    public ProjectorRightClickPacket(ARMOR_ACTION action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = ARMOR_ACTION.values()[buf.readInt() % ARMOR_ACTION.values().length];
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static void encode(ProjectorRightClickPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ProjectorRightClickPacket decode(PacketBuffer buf) {
        ProjectorRightClickPacket msg = new ProjectorRightClickPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final ProjectorRightClickPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ProjectorRightClickPacket.modifyArmor(context, message);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void modifyArmor(Supplier<NetworkEvent.Context> context, ProjectorRightClickPacket message) {
        ServerPlayerEntity player = context.get().getSender();
        TileEntity te = player.field_70170_p.func_175625_s(message.pos);
        if (te instanceof MahoujinProjectorTileEntity && player.func_184614_ca().func_77973_b() instanceof ArmorItem) {
            EffectUtil.addEnchantment(player.func_184614_ca(), ModEnchantments.PROJECTOR, 1);
            if (message.action == ARMOR_ACTION.ADD) {
                MahoujinProjectorEnchant.setProjectorNBT(player.func_184614_ca(), (MahoujinProjectorTileEntity)te, false, false);
            }
            if (message.action == ARMOR_ACTION.REPLACE) {
                MahoujinProjectorEnchant.setProjectorNBT(player.func_184614_ca(), (MahoujinProjectorTileEntity)te, true, false);
            }
            if (message.action == ARMOR_ACTION.REMOVE) {
                MahoujinProjectorEnchant.setProjectorNBT(player.func_184614_ca(), (MahoujinProjectorTileEntity)te, true, true);
            }
        }
    }

    public static enum ARMOR_ACTION {
        REPLACE,
        ADD,
        REMOVE;

    }
}

