/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RagePotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ItemAbilityPacket {
    ABILITY ability;

    public ItemAbilityPacket() {
    }

    public ItemAbilityPacket(ABILITY a) {
        this.ability = a;
    }

    public void fromBytes(ByteBuf buf) {
        int n = buf.readInt();
        this.ability = n < ABILITY.values().length ? ABILITY.values()[n] : ABILITY.CALIBURN;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ability.ordinal());
    }

    public static void encode(ItemAbilityPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ItemAbilityPacket decode(PacketBuffer buf) {
        ItemAbilityPacket msg = new ItemAbilityPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final ItemAbilityPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                if (((NetworkEvent.Context)context.get()).getSender() instanceof ServerPlayerEntity) {
                    if (message.ability == ABILITY.CALIBURN) {
                        ItemAbilityPacket.handleAbilityCaliburn(((NetworkEvent.Context)context.get()).getSender());
                    } else if (message.ability == ABILITY.MORGAN) {
                        ItemAbilityPacket.handleAbilityMorgan(((NetworkEvent.Context)context.get()).getSender());
                    } else if (message.ability == ABILITY.REPLICA) {
                        ItemAbilityPacket.handleAbilityReplica(((NetworkEvent.Context)context.get()).getSender());
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleAbilityCaliburn(ServerPlayerEntity player) {
        ICaliburnMahou mahou;
        int radius = MTConfig.POWER_CONSOLIDATION_SMITE_RADIUS;
        AxisAlignedBB aabb = new AxisAlignedBB(player.func_213303_ch().func_72441_c((double)(-radius), -4.0, (double)(-radius)), player.func_213303_ch().func_72441_c((double)radius, 4.0, (double)radius));
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof Caliburn && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN) && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST, false, false) == MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            int targets = 0;
            List lst = player.field_70170_p.func_217357_a(LivingEntity.class, aabb);
            for (LivingEntity target : lst) {
                if (target.func_110124_au().equals(player.func_110124_au()) || !Caliburn.specialTarget(target)) continue;
                ++targets;
            }
            for (LivingEntity target : lst) {
                if (target.func_110124_au().equals(player.func_110124_au()) || !Caliburn.specialTarget(target)) continue;
                SmiteEntity smite = new SmiteEntity(target.field_70170_p, target, 0.9019608f, 0.9019608f, 0.16470589f, 1.0f, 0.1f, mahou.getAttackDamage() / (float)targets);
                smite.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                target.field_70170_p.func_217376_c((Entity)smite);
            }
            EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public static void handleAbilityMorgan(ServerPlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof Morgan && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
            EffectUtil.buff((LivingEntity)player, ModEffects.RAGE, false, MTConfig.MORGAN_RAGE_TIME);
            RagePotion.notifyIfRage((LivingEntity)player);
            EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public static void handleAbilityReplica(ServerPlayerEntity player) {
        if (player.func_184607_cu().func_77973_b() instanceof Replica && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
            Vector3d teleport = Replica.getTeleportLocation(player.func_184607_cu());
            ResourceLocation dim = Replica.getTeleportDimension(player.func_184607_cu());
            if (dim == null) {
                dim = World.field_234918_g_.func_240901_a_();
            }
            if (teleport != null) {
                boolean allowed = true;
                if (MTConfig.REPLICA_TELEPORT_MAX_DISTANCE > 0.0 && teleport.func_72436_e(player.func_213303_ch()) > MTConfig.REPLICA_TELEPORT_MAX_DISTANCE * MTConfig.REPLICA_TELEPORT_MAX_DISTANCE) {
                    allowed = false;
                }
                if (!MTConfig.REPLICA_TELEPORT_CROSS_DIMENSION && !dim.equals((Object)EffectUtil.getDimension(player.field_70170_p))) {
                    allowed = false;
                }
                if (allowed && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.REPLICA_TELEPORT_MANA_COST, false, false) == MTConfig.REPLICA_TELEPORT_MANA_COST) {
                    ReplicaTeleportMahoujinEntity repte = new ReplicaTeleportMahoujinEntity(player.field_70170_p, (LivingEntity)player, 0.24f, 0.94f, 1.0f, 0.8f, dim, teleport, true);
                    repte.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 0.005, player.func_226281_cx_());
                    player.field_70170_p.func_217376_c((Entity)repte);
                    ReplicaTeleportMahoujinEntity repte2 = new ReplicaTeleportMahoujinEntity(player.field_70170_p, (LivingEntity)player, 0.24f, 0.94f, 1.0f, 0.8f, dim, teleport, true, false);
                    repte2.func_70107_b(teleport.field_72450_a, teleport.field_72448_b + 0.005, teleport.field_72449_c);
                    player.field_70170_p.func_217376_c((Entity)repte2);
                    EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
                }
            }
        }
    }

    public static enum ABILITY {
        MORGAN,
        CALIBURN,
        REPLICA;

    }
}

