/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.MysticStaff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffAOEMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.render.item.MysticStaffRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaff
extends ItemBase {
    private String MODE_TAG = "MAHOUTSUKAI_AOE_MODE_ON";
    private static final int beamGrowthStart = 35;
    private static final float beamGrowthRate = 1.026f;
    private static final float highestRadius = 35.0f;
    public static HashMap<UUID, MysticStaffUserStorage> staffs = new HashMap();

    public MysticStaff() {
        super("mystic_staff", new Item.Properties().func_200917_a(1).setISTER(() -> MysticStaffRenderer::new));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        staffs.remove(player.func_110124_au());
        MysticStaffUserStorage storage = new MysticStaffUserStorage();
        storage.growthStopped = false;
        storage.mahoujins = null;
        storage.target = null;
        storage.aoeTargets = null;
        storage.aoeSpawnIndex = 0;
        staffs.put(player.func_110124_au(), storage);
        if (player.func_226273_bm_()) {
            if (!world.field_72995_K) {
                this.setAOEMode(stack, (this.getAOEMode(stack) + 1) % 3);
                int mode = this.getAOEMode(stack);
                TranslationTextComponent tt = mode == 0 ? new TranslationTextComponent("mahoutsukai.mysticstaff.big") : (mode == 1 ? new TranslationTextComponent("mahoutsukai.mysticstaff.aoe") : new TranslationTextComponent("mahoutsukai.mysticstaff.beam"));
                player.func_146105_b((ITextComponent)tt, true);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void setAOEMode(ItemStack staff, int mode) {
        CompoundNBT nbt = staff.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a(this.MODE_TAG, mode);
        staff.func_77982_d(nbt);
    }

    public int getAOEMode(ItemStack staff) {
        CompoundNBT nbt = staff.func_77978_p();
        if (nbt != null && nbt.func_74764_b(this.MODE_TAG)) {
            return nbt.func_74762_e(this.MODE_TAG);
        }
        return 0;
    }

    public static float getBeamSize(MysticStaffMahoujinEntity entity, float partialTicks) {
        float last = entity.getBeamSize() / 1.026f;
        return last + partialTicks * (entity.getBeamSize() - last);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof PlayerEntity) {
            MysticStaffUserStorage storage = null;
            if (staffs.containsKey(player.func_110124_au())) {
                storage = staffs.get(player.func_110124_au());
            }
            if (storage == null) {
                storage = new MysticStaffUserStorage();
                staffs.put(player.func_110124_au(), storage);
            }
            if (this.getAOEMode(stack) == 0) {
                player.func_213293_j(0.0, player.func_213322_ci().field_72448_b * 0.3, 0.0);
                int charge = this.getRemainingUseDuration(stack, count);
                if (storage.mahoujins == null) {
                    storage.mahoujins = new ArrayList();
                }
                if (!player.field_70170_p.field_72995_K) {
                    float thunderChance;
                    if (storage.target == null) {
                        storage.target = this.getTargetBlock((PlayerEntity)player);
                    }
                    if (charge == 1) {
                        this.createFloorCircle(stack, (PlayerEntity)player, new Vector3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), 3.0f, 0.5f, storage);
                        this.createFloorCircle(stack, (PlayerEntity)player, storage.target.func_178787_e(new Vector3d(0.0, 1.0, 0.0)), 12.0f, 0.5f, storage);
                    }
                    if (charge == 5) {
                        storage.lowest = this.createCircleAtAngle(stack, (PlayerEntity)player, 10.0f, 1.5f, 10.0f, 30.0f, 15.0f, storage.target, false, 0.1f, false, storage);
                    }
                    if (charge == 8) {
                        this.createCircleAtAngle(stack, (PlayerEntity)player, 15.0f, 0.5f, 10.0f, 30.0f, 22.0f, storage.target, false, 0.0f, false, storage);
                    }
                    if (charge == 13) {
                        this.createCircleAtAngle(stack, (PlayerEntity)player, 20.0f, 2.0f, 10.0f, 30.0f, 30.0f, storage.target, false, 0.0f, false, storage);
                    }
                    if (charge == 15) {
                        storage.highest = this.createCircleAtAngle(stack, (PlayerEntity)player, 35.0f, 1.0f, 10.0f, 30.0f, 37.0f, storage.target, true, 0.1f, false, storage);
                    }
                    if (charge > 15 && storage.highest != null && MTConfig.MYSTIC_STAFF_BIG_RAIN && (double)(thunderChance = player.func_70681_au().nextFloat()) < 0.1) {
                        int angle = player.func_70681_au().nextInt(360);
                        float radius = (float)player.func_70681_au().nextInt(20) + 35.0f;
                        double addX = (double)(-radius) * Math.cos(MysticStaffMahoujinEntity.toRad(angle));
                        double addZ = (double)radius * Math.sin(MysticStaffMahoujinEntity.toRad(angle));
                        double addY = player.func_70681_au().nextInt(10) - 5;
                        LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(player.field_70170_p);
                        lightning.func_233576_c_(new Vector3d(storage.highest.func_226277_ct_() + addX, storage.highest.func_226278_cu_() + addY, storage.highest.func_226281_cx_() + addZ));
                        lightning.func_233623_a_(true);
                        ((ServerWorld)player.field_70170_p).func_217376_c((Entity)lightning);
                    }
                    if (charge > 35 && storage.lowest != null && storage.highest != null) {
                        if (storage.highest.getBeamSize() < 0.6f) {
                            storage.lowest.setBeamSize(storage.lowest.getBeamSize() * 1.026f);
                            storage.highest.setBeamSize(storage.highest.getBeamSize() * 1.026f);
                        } else {
                            storage.growthStopped = true;
                        }
                    }
                    if (MTConfig.MYSTIC_STAFF_BIG_RAIN) {
                        ((ServerWorld)player.field_70170_p).field_73004_o = Math.min((float)charge / 40.0f, 2.4f);
                        ((ServerWorld)player.field_70170_p).field_73017_q = Math.min((float)charge / 40.0f, 2.4f);
                    }
                }
            } else if (this.getAOEMode(stack) == 1) {
                if (!player.field_70170_p.field_72995_K && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.MYSTIC_STAFF_AOE_MANA_COST, false, false) == MTConfig.MYSTIC_STAFF_AOE_MANA_COST) {
                    Vector3d playerpos;
                    Vector3d look = player.func_70040_Z();
                    Vector3d playerperp = playerpos = player.func_213303_ch();
                    playerperp = playerperp.func_178787_e(look.func_72432_b().func_186678_a(2.0));
                    playerperp = player.func_70681_au().nextBoolean() ? playerperp.func_178787_e(Vector3d.func_189986_a((float)0.0f, (float)(player.field_70177_z + 90.0f)).func_72432_b().func_186678_a(player.func_70681_au().nextDouble() * 3.0 - 0.3).func_186678_a(2.0)) : playerperp.func_178787_e(Vector3d.func_189986_a((float)0.0f, (float)(player.field_70177_z - 90.0f)).func_72432_b().func_186678_a(player.func_70681_au().nextDouble() * 3.0 - 0.3).func_186678_a(2.0));
                    playerperp = playerperp.func_178787_e(Vector3d.func_189986_a((float)(player.field_70125_A - 90.0f), (float)player.field_70177_z).func_72432_b().func_186678_a(player.func_70681_au().nextDouble() * 3.0 - 0.2).func_186678_a(2.0));
                    if (count % MTConfig.MYSTIC_STAFF_AOE_DELAY == 0) {
                        float[] colors = this.getColor((PlayerEntity)player, 1);
                        MysticStaffAOEMahoujinEntity circle = new MysticStaffAOEMahoujinEntity(player.field_70170_p, (PlayerEntity)player, colors[0], colors[1], colors[2], 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                        circle.func_70107_b(playerperp.field_72450_a, playerperp.field_72448_b, playerperp.field_72449_c);
                        circle.field_70125_A = player.field_70125_A;
                        circle.field_70177_z = player.field_70177_z;
                        Vector3d pos = circle.func_213303_ch().func_178787_e(player.func_70040_Z());
                        Vector3d aim = circle.func_213303_ch().func_178788_d(pos);
                        circle.setCircleSize(1.5f);
                        circle.shoot(-aim.field_72450_a, -aim.field_72448_b, -aim.field_72449_c, 3.0f, 4.0f);
                        player.field_70170_p.func_217376_c((Entity)circle);
                    }
                }
            } else if (!player.field_70170_p.field_72995_K) {
                if (this.getRemainingUseDuration(stack, count) > MysticStaffBeamMahoujinEntity.dyingticks * 2 && storage.beamMahoujinEntity == null) {
                    float[] colors = this.getColor((PlayerEntity)player, 2);
                    storage.beamMahoujinEntity = new MysticStaffBeamMahoujinEntity(player.field_70170_p, (PlayerEntity)player, colors[0], colors[1], colors[2]);
                    storage.beamMahoujinEntity.casterPosition(true);
                    player.field_70170_p.func_217376_c((Entity)storage.beamMahoujinEntity);
                }
                player.func_213293_j(0.0, 0.0, 0.0);
            } else if (this.getRemainingUseDuration(stack, count) > MysticStaffBeamMahoujinEntity.dyingticks * 2 && player == Minecraft.func_71410_x().field_71439_g) {
                MahouTsukaiMod.proxy.slowDown();
            }
        }
    }

    public int getRemainingUseDuration(ItemStack stack, int charge) {
        return this.func_77626_a(stack) - charge;
    }

    public Vector3d getTargetBlock(PlayerEntity player) {
        Vector3d target;
        RayTraceResult result = player.func_213324_a((double)MTConfig.GLOBAL_LOOK_RANGE, 1.0f, false);
        if (result instanceof BlockRayTraceResult) {
            target = new Vector3d((double)((BlockRayTraceResult)result).func_216350_a().func_177958_n() + 0.5, (double)((BlockRayTraceResult)result).func_216350_a().func_177956_o(), (double)((BlockRayTraceResult)result).func_216350_a().func_177952_p() + 0.5);
        } else {
            Vector3d v = player.func_70676_i(0.0f);
            Vector3d v2 = new Vector3d(v.field_72450_a * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72448_b * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72449_c * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vector3d v3 = player.func_174824_e(1.0f).func_178787_e(v2);
            while (Utils.isBlockAir(player.field_70170_p, new BlockPos(v3)) && v3.field_72448_b > 0.0) {
                v3 = v3.func_178787_e(new Vector3d(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public void createFloorCircle(ItemStack stack, PlayerEntity player, Vector3d pos, float size, float speed, MysticStaffUserStorage storage) {
        float[] colors = this.getColor(player, 0);
        MysticStaffMahoujinEntity floorMahoujin = new MysticStaffMahoujinEntity(player.field_70170_p, player, false, colors[0], colors[1], colors[2], 0.95f);
        floorMahoujin.func_70107_b(pos.field_72450_a, pos.field_72448_b + 0.001, pos.field_72449_c);
        floorMahoujin.sizer(size);
        floorMahoujin.setRotationSpeed(speed);
        floorMahoujin.setRotationYaw(0.0f);
        floorMahoujin.setRotationPitch(0.0f);
        storage.mahoujins.add(floorMahoujin);
        player.field_70170_p.func_217376_c((Entity)floorMahoujin);
    }

    public MysticStaffMahoujinEntity createCircleAtAngle(ItemStack stack, PlayerEntity player, float size, float speed, float circle, float ground, float distance, Vector3d pos, boolean beam, float beamSize, boolean aoe, MysticStaffUserStorage storage) {
        MysticStaffMahoujinEntity m;
        float[] colors = this.getColor(player, aoe ? 1 : 0);
        if (aoe) {
            m = new MysticStaffMahoujinEntity(player.field_70170_p, player, beam, colors[0], colors[1], colors[2], 0.95f);
            m.setBeamLength(0.0f);
            m.setBeamOffset(0.0f);
        } else {
            m = new MysticStaffMahoujinEntity(player.field_70170_p, player, beam, colors[0], colors[1], colors[2], 0.95f);
            m.setBeamLength(240.0f);
            m.setBeamOffset(-distance);
        }
        m.setDistance(distance);
        m.sizer(size);
        m.setRotationSpeed(speed);
        m.angleCircleAroundBlock(circle, ground, distance, pos);
        storage.mahoujins.add(m);
        player.field_70170_p.func_217376_c((Entity)m);
        if (beam) {
            m.setBeamSize(beamSize);
        }
        return m;
    }

    public Vector3d getBlockPerpToLook(Vector3d target, float playerYaw, float distance) {
        float yaw = playerYaw;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(yaw += 90.0f));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(yaw));
        return new Vector3d(plusX, 0.0, plusZ).func_178787_e(target);
    }

    public Vector3d getMiddleCircle(Vector3d target, Vector3d target2, float playerYaw, float distance) {
        double xhalf = (target2.field_72450_a - target.field_72450_a) / 2.0;
        double zhalf = (target2.field_72449_c - target.field_72449_c) / 2.0;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(playerYaw));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(playerYaw));
        return new Vector3d(plusX += xhalf + target.field_72450_a, target.field_72448_b, plusZ += zhalf + target.field_72449_c);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, LivingEntity caster, int useTicks) {
        MysticStaffUserStorage storage;
        PlayerEntity player = (PlayerEntity)caster;
        if (staffs.containsKey(player.func_110124_au())) {
            storage = staffs.get(player.func_110124_au());
        } else {
            storage = new MysticStaffUserStorage();
            staffs.put(player.func_110124_au(), storage);
        }
        if (storage.mahoujins != null && !world.field_72995_K) {
            int radius = MTConfig.MYSTIC_STAFF_BIG_SIZE;
            if (storage.growthStopped) {
                if (this.getAOEMode(stack) == 0) {
                    double mana = MTConfig.MYSTIC_STAFF_SCALING_MANA;
                    if (Utils.getPlayerMahou(player) != null) {
                        mana *= (double)Utils.getPlayerMahou(player).getMaxMana();
                    }
                    if ((double)PlayerManaManager.drainMana(player, (int)((double)MTConfig.MYSTIC_STAFF_BIG_MANA_COST + mana), false, false) == (double)MTConfig.MYSTIC_STAFF_BIG_MANA_COST + mana) {
                        double x = storage.target.field_72450_a;
                        double y = storage.target.field_72448_b;
                        double z = storage.target.field_72449_c;
                        Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y + (float)(radius / 2 + 2), (float)z, MysticStaff.getExplosionDamage(false, Utils.getPlayerMahou(player)));
                        explosion.explosionA(world, player);
                        ModTriggers.BAKURETSU.trigger((ServerPlayerEntity)player);
                        for (PlayerEntity PlayerEntity2 : world.func_217369_A()) {
                            if (!(PlayerEntity2.func_70092_e(x, y, z) < 16384.0)) continue;
                            Vector3d vec = null;
                            if (explosion.knockback.containsKey(player)) {
                                vec = explosion.knockback.get(player);
                            }
                            if (vec == null) {
                                PacketHandler.sendTo((ServerPlayerEntity)PlayerEntity2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, 0.0f, 0.0f, 0.0f));
                                continue;
                            }
                            PacketHandler.sendTo((ServerPlayerEntity)PlayerEntity2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c));
                        }
                        for (MysticStaffMahoujinEntity e : storage.mahoujins) {
                            e.func_70106_y();
                        }
                    }
                } else if (this.getAOEMode(stack) == 1) {
                    // empty if block
                }
            }
            storage.mahoujins = new ArrayList();
        }
        if (!world.field_72995_K) {
            if (storage.beamMahoujinEntity != null) {
                storage.beamMahoujinEntity.setDying(1);
                storage.beamMahoujinEntity = null;
            }
            MahouTsukaiMod.proxy.speedUp();
        }
    }

    public static float getExplosionDamage(boolean aoe, IMahou mahou) {
        boolean scales;
        float factor;
        if (aoe) {
            factor = (float)MTConfig.MYSTIC_STAFF_AOE_FACTOR;
            scales = MTConfig.MYSTIC_STAFF_AOE_SCALES;
        } else {
            factor = (float)MTConfig.MYSTIC_STAFF_BIG_FACTOR;
            scales = MTConfig.MYSTIC_STAFF_BIG_SCALES;
        }
        if (scales && mahou != null) {
            return (float)mahou.getMaxMana() * factor;
        }
        return factor;
    }

    public float[] getColor(PlayerEntity caster, int mode) {
        float[] ret = new float[]{0.0f, 0.0f, 0.0f};
        MahouSettings.Spell spell = MahouSettings.Spell.MYSTIC_STAFF_BIG;
        if (mode == 1) {
            spell = MahouSettings.Spell.MYSTIC_STAFF_AOE;
        }
        if (mode == 2) {
            spell = MahouSettings.Spell.MYSTIC_STAFF_BEAM;
        }
        List<Integer> settings = MahouSettings.getIntSettings(caster, spell);
        ret[0] = (float)settings.get(0).intValue() / 255.0f;
        ret[1] = (float)settings.get(1).intValue() / 255.0f;
        ret[2] = (float)settings.get(2).intValue() / 255.0f;
        return ret;
    }

    public static List<BlockPos> getAffectedBlocks(World world, BlockPos target, int size) {
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        int r = size / 2;
        Stream box = BlockPos.func_218281_b((BlockPos)target.func_177982_a(-r, -r, -r), (BlockPos)target.func_177982_a(r, r, r));
        box.forEach(tmp -> {
            if (MysticStaff.getDistance(EffectUtil.fromBlockPos(tmp), EffectUtil.fromBlockPos(target)) < r) {
                lst.add(new BlockPos(tmp.func_177958_n(), tmp.func_177956_o(), tmp.func_177952_p()));
            }
        });
        return lst;
    }

    public static int getDistance(Vector3d pos1, Vector3d pos2) {
        double x = pos1.field_72450_a - pos2.field_72450_a;
        double y = pos1.field_72448_b - pos2.field_72448_b;
        double z = pos1.field_72449_c - pos2.field_72449_c;
        return (int)Math.abs(Math.ceil(Math.sqrt(x * x + y * y + z * z)));
    }

    public class MysticStaffUserStorage {
        public ArrayList<MysticStaffMahoujinEntity> mahoujins;
        public boolean growthStopped = false;
        public Vector3d target = null;
        public List<Vector3d> aoeTargets = null;
        public MysticStaffMahoujinEntity highest = null;
        public MysticStaffMahoujinEntity lowest = null;
        public float playerLook = 0.0f;
        public float playerPitch = 0.0f;
        public int aoeSpawnIndex = 0;
        public MysticStaffBeamMahoujinEntity beamMahoujinEntity = null;
    }
}

