/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.replica;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ReplicaKnockbackParticlePacket;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.ReplicaRenderer;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class Replica
extends ItemBase {
    public static HashMap<String, DamageSource> DAMAGE_SOURCE_REGISTRY = new HashMap();

    public Replica() {
        super("replica", new Item.Properties().func_200916_a(ModItems.MAHOUTSUKAI_CREATIVE_TAB).func_200917_a(1).func_200918_c(MTConfig.REPLICA_DURABILITY).setISTER(() -> ReplicaRenderer::new));
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (!player.field_70170_p.field_72995_K && player.func_70051_ag()) {
            Replica.coverMove(player);
        }
        player.func_184598_c(handIn);
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (count == 72000 && !player.field_70170_p.field_72995_K && player instanceof PlayerEntity) {
            if (!player.func_70051_ag() && player.func_226273_bm_()) {
                Replica.saveTeleportLocation(stack, (PlayerEntity)player);
            }
            if (!EffectUtil.hasBuff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN) && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.REPLICA_ATTACK_MANA_COST, false, false) == MTConfig.REPLICA_ATTACK_MANA_COST) {
                this.bigKnockback((PlayerEntity)player, stack);
                EffectUtil.buff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN, false, MTConfig.REPLICA_SHOCKWAVE_COOLDOWN, false);
            }
        }
        player.func_213293_j(0.0, 0.0, 0.0);
        player.field_70133_I = true;
    }

    public void bigKnockback(PlayerEntity playerIn, ItemStack stack) {
        double maxRadius = MTConfig.REPLICA_ATTACK_RANGE;
        ReplicaKnockbackParticlePacket packet = new ReplicaKnockbackParticlePacket(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + (double)(playerIn.func_213302_cg() / 2.0f), playerIn.func_226281_cx_(), 0.2f, 0.2f, 0.2f);
        PacketHandler.sendTracking((Entity)playerIn, packet);
        PacketHandler.sendTo((ServerPlayerEntity)playerIn, packet);
        List lst = playerIn.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(playerIn.func_226277_ct_() - maxRadius, playerIn.func_226278_cu_() - maxRadius, playerIn.func_226281_cx_() - maxRadius, playerIn.func_226277_ct_() + maxRadius, playerIn.func_226278_cu_() + maxRadius, playerIn.func_226281_cx_() + maxRadius));
        int multiplier = 0;
        double damage = MTConfig.REPLICA_BASE_DAMAGE;
        for (LivingEntity e : lst) {
            if (!ContractMahoujinTileEntity.isImmuneToSpell(playerIn.field_70170_p, playerIn.func_110124_au(), (Entity)e)) continue;
            ++multiplier;
        }
        for (LivingEntity e : lst) {
            if (ContractMahoujinTileEntity.isImmuneToSpell(playerIn.field_70170_p, playerIn.func_110124_au(), (Entity)e)) continue;
            String type = Replica.getDamageTypeForSlot(stack, Replica.getSelectedSlot(stack));
            DamageSource source = DamageSource.field_76377_j;
            source = Replica.getDamageSource(type, (LivingEntity)playerIn);
            e.func_70097_a(source, (float)Math.min((double)multiplier * damage, MTConfig.REPLICA_MAX_DAMAGE));
            Vector3d v = e.func_213303_ch().func_178788_d(playerIn.func_213303_ch());
            this.boop((Entity)e, 3.0f, -v.field_72450_a, -v.field_72448_b, -v.field_72449_c);
        }
    }

    public static void coverMove(PlayerEntity player) {
        double totalRange = MTConfig.REPLICA_COVER_MOVE_RANGE;
        Vector3d myloc = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        List lst = player.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(player.func_226277_ct_() - totalRange, player.func_226278_cu_() - totalRange, player.func_226281_cx_() - totalRange, player.func_226277_ct_() + totalRange, player.func_226278_cu_() + totalRange, player.func_226281_cx_() + totalRange));
        ArrayList<LivingEntity> inRange = new ArrayList<LivingEntity>();
        HashSet<LivingEntity> needsHelp = new HashSet<LivingEntity>();
        HashSet<LivingEntity> players = new HashSet<LivingEntity>();
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, (LivingEntity)player, myloc, (int)totalRange, false) || !ContractMahoujinTileEntity.isImmuneToSpell(player.field_70170_p, player.func_110124_au(), (Entity)tmp) || player == tmp) continue;
            inRange.add(tmp);
            if (tmp instanceof PlayerEntity) {
                players.add(tmp);
            }
            if (!Replica.needsHelp(tmp)) continue;
            needsHelp.add(tmp);
        }
        Collections.sort(inRange, Replica.getDistanceSorter((LivingEntity)player));
        LivingEntity e = Replica.coverMoveTarget(inRange, needsHelp, players);
        if (e != null) {
            Vector3d facing = Replica.coverMoveFacing(e);
            if (facing == null) {
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.field_70170_p), e.func_213303_ch().func_178787_e(new Vector3d(1.0, 0.0, 0.0)));
                player.field_70133_I = true;
            } else {
                facing = facing.func_72432_b();
                float pitch = (float)Math.asin(-facing.field_72448_b);
                float yaw = (float)Math.atan2(facing.field_72450_a, facing.field_72449_c);
                player.field_70177_z = EffectUtil.toDegrees(-yaw);
                player.field_70125_A = EffectUtil.toDegrees(pitch);
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.field_70170_p), e.func_213303_ch().func_178787_e(facing.func_186678_a(0.2)));
                player.field_70133_I = true;
            }
        }
    }

    public static LivingEntity coverMoveTarget(ArrayList<LivingEntity> inRange, HashSet<LivingEntity> needsHelp, HashSet<LivingEntity> players) {
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living) || !players.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!players.contains(living)) continue;
            return living;
        }
        Iterator<LivingEntity> iterator = inRange.iterator();
        if (iterator.hasNext()) {
            LivingEntity living;
            living = iterator.next();
            return living;
        }
        return null;
    }

    public static void saveTeleportLocation(ItemStack s, PlayerEntity player) {
        Vector3d save = player.func_213303_ch();
        CompoundNBT nbt = s.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74780_a("mahou_teleport_x", save.field_72450_a);
        nbt.func_74780_a("mahou_teleport_y", save.field_72448_b);
        nbt.func_74780_a("mahou_teleport_z", save.field_72449_c);
        nbt.func_74778_a("mahou_teleport_dim", EffectUtil.getDimension(player.field_70170_p).toString());
        s.func_77982_d(nbt);
    }

    public static Vector3d getTeleportLocation(ItemStack s) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt != null && nbt.func_74764_b("mahou_teleport_x") && nbt.func_74764_b("mahou_teleport_y") && nbt.func_74764_b("mahou_teleport_z")) {
            return new Vector3d(nbt.func_74769_h("mahou_teleport_x"), nbt.func_74769_h("mahou_teleport_y"), nbt.func_74769_h("mahou_teleport_z"));
        }
        return null;
    }

    public static ResourceLocation getTeleportDimension(ItemStack s) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt != null && nbt.func_74764_b("mahou_teleport_dim")) {
            return new ResourceLocation(nbt.func_74779_i("mahou_teleport_dim"));
        }
        return null;
    }

    public static boolean getFriendlyOnly(ItemStack s) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt != null && nbt.func_74764_b("mahou_friendly")) {
            return nbt.func_74767_n("mahou_friendly");
        }
        return false;
    }

    public static void setFriendlyOnly(ItemStack s, boolean b) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74757_a("mahou_friendly", b);
        s.func_77982_d(nbt);
    }

    public static Vector3d coverMoveFacing(LivingEntity e) {
        return Replica.coverMoveFacing(e, null);
    }

    public static Vector3d coverMoveFacing(LivingEntity e, Entity ignore) {
        int inTroubleRange = 15;
        List lst = e.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(e.func_226277_ct_() - (double)inTroubleRange, e.func_226278_cu_() - (double)inTroubleRange, e.func_226281_cx_() - (double)inTroubleRange, e.func_226277_ct_() + (double)inTroubleRange, e.func_226278_cu_() + (double)inTroubleRange, e.func_226281_cx_() + (double)inTroubleRange));
        Collections.sort(lst, Replica.getDistanceSorter(e));
        lst.remove(e);
        if (ignore != null) {
            lst.remove(ignore);
        }
        Vector3d ret = null;
        for (LivingEntity attacker : lst) {
            if (ret == null) {
                ret = attacker.func_213303_ch().func_178788_d(e.func_213303_ch());
            }
            if (attacker.func_70643_av() != e && (!(attacker instanceof MobEntity) || ((MobEntity)attacker).func_70638_az() != e) && (!(attacker instanceof PlayerEntity) || ContractMahoujinTileEntity.isImmuneToSpell(e.field_70170_p, e.func_110124_au(), (Entity)attacker))) continue;
            ret = attacker.func_213303_ch().func_178788_d(e.func_213303_ch());
            return ret;
        }
        return ret;
    }

    public static Comparator<LivingEntity> getDistanceSorter(final LivingEntity player) {
        Comparator<LivingEntity> compareDistance = new Comparator<LivingEntity>(){

            @Override
            public int compare(LivingEntity o1, LivingEntity o2) {
                double d = o1.func_70032_d((Entity)player) - o2.func_70032_d((Entity)player);
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                return 0;
            }
        };
        return compareDistance;
    }

    public static boolean needsHelp(LivingEntity e) {
        int inTroubleRange = 15;
        List lst = e.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(e.func_226277_ct_() - (double)inTroubleRange, e.func_226278_cu_() - (double)inTroubleRange, e.func_226281_cx_() - (double)inTroubleRange, e.func_226277_ct_() + (double)inTroubleRange, e.func_226278_cu_() + (double)inTroubleRange, e.func_226281_cx_() + (double)inTroubleRange));
        for (LivingEntity attacker : lst) {
            if (attacker.func_70643_av() != e && (!(attacker instanceof MobEntity) || ((MobEntity)attacker).func_70638_az() != e)) continue;
            return true;
        }
        return false;
    }

    public static void replicaBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer().func_184614_ca().func_77973_b() instanceof Replica) {
            ItemStack s;
            boolean friendly = Replica.getFriendlyOnly(s = event.getPlayer().func_184614_ca());
            Replica.setFriendlyOnly(s, !friendly);
            TranslationTextComponent tt = friendly ? new TranslationTextComponent("mahoutsukai.replica.friendlyoff") : new TranslationTextComponent("mahoutsukai.replica.friendlyon");
            event.getPlayer().func_146105_b((ITextComponent)tt, true);
        }
    }

    public static void printItems() {
        ImmutableList list = ImmutableList.copyOf((Iterable)Registry.field_212630_s);
        String s = "";
        for (Item i : list) {
            if (!i.getRegistryName().func_110624_b().equals("mahoutsukai")) continue;
            s = s + "\"" + i.getRegistryName().toString() + "\",";
        }
        System.out.println(s);
    }

    public static void printBlocks() {
        ImmutableList list = ImmutableList.copyOf((Iterable)Registry.field_212618_g);
        String s = "";
        for (Block i : list) {
            if (!i.getRegistryName().func_110624_b().equals("mahoutsukai")) continue;
            s = s + "public static String BLOCK_" + i.getRegistryName().func_110623_a().toUpperCase() + " = \"" + i.getRegistryName().func_110623_a() + "\";\r\n";
        }
        System.out.println(s);
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        Vector3d motion = entity.func_213322_ci();
        double motionX = motion.func_82615_a();
        double motionY = motion.func_82617_b();
        double motionZ = motion.func_82616_c();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.field_70133_I = true;
        if (entity.func_233570_aj_()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.func_213293_j(motionX, motionY, motionZ);
    }

    public static void setSelectedSlot(ItemStack s, int i) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a("replica_selected_slot", i);
        s.func_77982_d(nbt);
    }

    public static int getSelectedSlot(ItemStack s) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt != null && nbt.func_74764_b("replica_selected_slot")) {
            return nbt.func_74762_e("replica_selected_slot");
        }
        return 0;
    }

    public static String getDamageTypeForSlot(ItemStack s, int i) {
        CompoundNBT nbt = s.func_77978_p();
        String key = "mahou_replica_dt" + i;
        if (nbt != null && nbt.func_74764_b(key)) {
            return nbt.func_74779_i(key);
        }
        return "EMPTY";
    }

    public static void tryAddDamageType(ItemStack s, DamageSource source, LivingEntity e) {
        String type = source.func_76355_l();
        if (!EffectUtil.inGenericBlacklist(type, MTConfig.REPLICA_BANNED_DAMAGE_TYPES) && (DAMAGE_SOURCE_REGISTRY.containsKey(type) || Replica.getDamageSource(type, e) != DamageSource.field_76377_j)) {
            String slot;
            CompoundNBT nbt = s.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            for (int i = 0; i < 6 && !(slot = Replica.getDamageTypeForSlot(s, i)).equals(type); ++i) {
                if (!slot.equals("EMPTY")) continue;
                String key = "mahou_replica_dt" + i;
                nbt.func_74778_a(key, type);
                break;
            }
            s.func_77982_d(nbt);
        }
    }

    public static void replicaLivingAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        Replica.replicaDamageSource(event.getEntityLiving(), source);
    }

    public static boolean replicaLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (event.getEntityLiving() != null && event.getEntityLiving().func_184607_cu().func_77973_b() instanceof Replica) {
            for (int i = 0; i < 6; ++i) {
                String s = Replica.getDamageTypeForSlot(event.getEntityLiving().func_184607_cu(), i);
                if (!s.equals(source.field_76373_n)) continue;
                event.setAmount(0.0f);
                return true;
            }
        }
        return false;
    }

    public static void replicaDamageSource(LivingEntity entity, DamageSource source) {
        ServerPlayerEntity e;
        IMahou mahou;
        if (!entity.field_70170_p.field_72995_K && entity.func_184585_cz() && entity.func_184607_cu().func_77973_b() instanceof Replica) {
            Replica.tryAddDamageType(entity.func_184607_cu(), source, entity);
            entity.func_184607_cu().func_222118_a(1, entity, a -> {});
        }
        if (!MTConfig.REPLICA_DISABLED && entity.func_184585_cz() && entity.func_184607_cu().func_77973_b() instanceof ShieldItem && entity instanceof ServerPlayerEntity && (mahou = Utils.getPlayerMahou((PlayerEntity)(e = (ServerPlayerEntity)entity))) != null && (double)mahou.getDamageExchangeUses() > 0.9 * (double)MTConfig.DAMAGE_EXCHANGE_CAP && (double)mahou.getDeathCollectionUsesLeft() > Math.min(100.0, MTConfig.DEATH_COLLECTION_MAX) && EffectUtil.hasBuff((LivingEntity)e, ModEffects.IMMUNITY_EXCHANGE) && e.func_70658_aO() > 15 && e.func_184614_ca().func_77973_b() == Items.field_185159_cQ && StrengtheningSpellEffect.getStrengthened(e.func_184614_ca()) > 0) {
            e.field_71071_by.func_70304_b(e.field_71071_by.field_70461_c);
            ItemStack change = new ItemStack((IItemProvider)ModItems.replica);
            if (MTConfig.REPLICA_IS_UNBREAKABLE) {
                CompoundNBT nbt = change.func_77978_p();
                if (nbt == null) {
                    nbt = new CompoundNBT();
                }
                nbt.func_74757_a("Unbreakable", true);
                change.func_77982_d(nbt);
            }
            if (!e.field_71071_by.func_191971_c(e.field_71071_by.field_70461_c, change)) {
                e.func_71019_a(change, false);
            }
            ModTriggers.REPLICA.trigger(e);
        }
    }

    public static void clearDamageTypes(ItemStack s) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        for (int i = 0; i < 6; ++i) {
            String key = "mahou_replica_dt" + i;
            nbt.func_74778_a(key, "EMPTY");
        }
        s.func_77982_d(nbt);
    }

    public static void initVanillaDamageTypes() {
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76372_a.field_76373_n, DamageSource.field_76372_a);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_180137_b.field_76373_n, DamageSource.field_180137_b);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76370_b.field_76373_n, DamageSource.field_76370_b);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76371_c.field_76373_n, DamageSource.field_76371_c);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_190095_e.field_76373_n, DamageSource.field_190095_e);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76368_d.field_76373_n, DamageSource.field_76368_d);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_191291_g.field_76373_n, DamageSource.field_191291_g);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76369_e.field_76373_n, DamageSource.field_76369_e);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76366_f.field_76373_n, DamageSource.field_76366_f);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76367_g.field_76373_n, DamageSource.field_76367_g);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76379_h.field_76373_n, DamageSource.field_76379_h);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_188406_j.field_76373_n, DamageSource.field_188406_j);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76380_i.field_76373_n, DamageSource.field_76380_i);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76377_j.field_76373_n, DamageSource.field_76377_j);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_76376_m.field_76373_n, DamageSource.field_76376_m);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_82727_n.field_76373_n, DamageSource.field_82727_n);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_82728_o.field_76373_n, DamageSource.field_82728_o);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_82729_p.field_76373_n, DamageSource.field_82729_p);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_188407_q.field_76373_n, DamageSource.field_188407_q);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_205132_u.field_76373_n, DamageSource.field_205132_u);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.field_220302_v.field_76373_n, DamageSource.field_220302_v);
    }

    public static DamageSource getDamageSource(String key, LivingEntity e) {
        DamageSource ret = DamageSource.field_76377_j;
        if (DAMAGE_SOURCE_REGISTRY.containsKey(key)) {
            ret = DAMAGE_SOURCE_REGISTRY.get(key);
        } else {
            DamageSource BEE_STING = DamageSource.func_226252_a_((LivingEntity)e);
            DamageSource MOB = DamageSource.func_76358_a((LivingEntity)e);
            DamageSource INDIRECT = DamageSource.func_188403_a((Entity)e, (LivingEntity)e);
            DamageSource ARROW = DamageSource.func_76353_a((AbstractArrowEntity)new ArrowEntity(e.field_70170_p, e), (Entity)e);
            DamageSource EXPLOSION = DamageSource.func_188405_b((LivingEntity)e);
            DamageSource THORNS = DamageSource.func_92087_a((Entity)e);
            DamageSource WITHER_SKULL = DamageSource.func_233549_a_((WitherSkullEntity)new WitherSkullEntity(e.field_70170_p, e, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_()), (Entity)e);
            DamageSource TRIDENT = DamageSource.func_203096_a((Entity)e, (Entity)e);
            DamageSource FIREWORK = DamageSource.func_233548_a_((FireworkRocketEntity)new FireworkRocketEntity(e.field_70170_p, new ItemStack((IItemProvider)Items.field_196152_dE), e), (Entity)e);
            DamageSource THROWN = DamageSource.func_76356_a((Entity)e, (Entity)e);
            HashMap<String, DamageSource> map = new HashMap<String, DamageSource>();
            map.put(BEE_STING.field_76373_n, BEE_STING);
            map.put(MOB.field_76373_n, MOB);
            map.put(INDIRECT.field_76373_n, INDIRECT);
            map.put(ARROW.field_76373_n, ARROW);
            map.put(EXPLOSION.field_76373_n, EXPLOSION);
            map.put(THORNS.field_76373_n, THORNS);
            map.put(WITHER_SKULL.field_76373_n, WITHER_SKULL);
            map.put(TRIDENT.field_76373_n, TRIDENT);
            map.put(FIREWORK.field_76373_n, FIREWORK);
            map.put(THROWN.field_76373_n, THROWN);
            if (map.containsKey(key)) {
                ret = (DamageSource)map.get(key);
            }
        }
        return ret;
    }

    public static void replicaExplosionProtection(ExplosionEvent.Detonate event) {
        List lst = event.getExplosion().func_180343_e();
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        if (lst.size() > 0 || event.getAffectedEntities().size() > 0) {
            for (BlockPos p : lst) {
                if ((float)p.func_177958_n() < minX) {
                    minX = p.func_177958_n();
                }
                if ((float)p.func_177956_o() < minY) {
                    minY = p.func_177956_o();
                }
                if ((float)p.func_177952_p() < minZ) {
                    minZ = p.func_177952_p();
                }
                if ((float)p.func_177958_n() > maxX) {
                    maxX = p.func_177958_n();
                }
                if ((float)p.func_177956_o() > maxY) {
                    maxY = p.func_177956_o();
                }
                if (!((float)p.func_177952_p() > maxZ)) continue;
                maxZ = p.func_177952_p();
            }
            for (Entity e : event.getAffectedEntities()) {
                BlockPos p = e.func_233580_cy_();
                if ((float)p.func_177958_n() < minX) {
                    minX = p.func_177958_n();
                }
                if ((float)p.func_177956_o() < minY) {
                    minY = p.func_177956_o();
                }
                if ((float)p.func_177952_p() < minZ) {
                    minZ = p.func_177952_p();
                }
                if ((float)p.func_177958_n() > maxX) {
                    maxX = p.func_177958_n();
                }
                if ((float)p.func_177956_o() > maxY) {
                    maxY = p.func_177956_o();
                }
                if (!((float)p.func_177952_p() > maxZ)) continue;
                maxZ = p.func_177952_p();
            }
            ChunkPos bottom = new ChunkPos(new BlockPos((double)(minX -= 14.0f), (double)(minY -= 14.0f), (double)(minZ -= 14.0f)));
            ChunkPos top = new ChunkPos(new BlockPos((double)(maxX += 14.0f), (double)(maxY += 14.0f), (double)(maxZ += 14.0f)));
            ArrayList<PlayerEntity> entities = new ArrayList<PlayerEntity>();
            for (int i1 = bottom.field_77276_a; i1 <= top.field_77276_a; ++i1) {
                for (int j1 = bottom.field_77275_b; j1 <= top.field_77275_b; ++j1) {
                    Chunk chunk = event.getWorld().func_72863_F().func_217205_a(i1, j1, false);
                    if (chunk == null) continue;
                    ClassInheritanceMultiMap[] map = chunk.func_177429_s();
                    for (int i = 0; i < map.length; ++i) {
                        for (Entity e : map[i]) {
                            if (!(e instanceof PlayerEntity) || !(((PlayerEntity)e).func_184607_cu().func_77973_b() instanceof Replica)) continue;
                            entities.add((PlayerEntity)e);
                        }
                    }
                }
            }
            if (entities.size() > 0) {
                Iterator iter = lst.iterator();
                while (iter.hasNext()) {
                    boolean remove = false;
                    BlockPos p = (BlockPos)iter.next();
                    for (PlayerEntity entity : entities) {
                        Vector3d vec1;
                        if (!Replica.isPointInRadiusOfCircle(entity, vec1 = EffectUtil.fromBlockPos(p).func_72441_c(0.5, 0.5, 0.5))) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    iter.remove();
                }
                Iterator affected = event.getAffectedEntities().iterator();
                while (affected.hasNext()) {
                    boolean remove = false;
                    Entity a = (Entity)affected.next();
                    Vector3d p = a.func_213303_ch();
                    Vector3d p2 = a.func_213303_ch().func_72441_c(0.0, (double)a.func_213302_cg(), 0.0);
                    for (PlayerEntity entity : entities) {
                        if (!(entity.func_184607_cu().func_77973_b() instanceof Replica) || !Replica.isPointInRadiusOfCircle(entity, p) && !Replica.isPointInRadiusOfCircle(entity, p2)) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    affected.remove();
                }
            }
        }
    }

    public static boolean isPointInRadiusOfCircle(PlayerEntity player, Vector3d pos) {
        Vector3d sphereMid = Replica.getSphereMid(player);
        double distance = pos.func_72438_d(sphereMid);
        return distance < (double)Replica.getSphereMidRadius();
    }

    public static Vector3d getSphereMid(PlayerEntity player) {
        Vector3d sphereMid = player.func_213303_ch().func_178788_d(player.func_70040_Z().func_72432_b().func_186678_a((double)Replica.getSphereMidRadius() - 0.5));
        return sphereMid;
    }

    public static float getSphereMidRadius() {
        float sphereMidRadius = 3.8f;
        return sphereMidRadius;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.REPLICA_DURABILITY;
    }
}

