/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.attunedgems;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.gemmahou.GemMahou;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouProvider;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.util.Utils;

public class AttunedGem
extends ItemBase {
    private int MAX_MANA;

    public AttunedGem(String gem, int maxMana) {
        super("attuned_" + gem, ModItems.MAHOUTSUKAI_CREATIVE_TAB, 1);
        this.MAX_MANA = maxMana;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new GemMahouProvider();
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        IGemMahou gemMahou = Utils.getGemMahou(itemStack);
        float q = gemMahou != null ? (float)gemMahou.getStoredMana() : (float)this.getMaxMana();
        return 1.0 - (double)(q / (float)this.getMaxMana());
    }

    public int getMaxMana() {
        return this.MAX_MANA;
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            IGemMahou mahou = Utils.getGemMahou(stack);
            return (CompoundNBT)GemMahouProvider.MAHOU.getStorage().writeNBT(GemMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbtt) {
        if (nbtt != null) {
            IGemMahou gemMahou = Utils.getGemMahou(stack);
            GemMahou serverGemMahou = new GemMahou();
            GemMahouProvider.MAHOU.getStorage().readNBT(GemMahouProvider.MAHOU, (Object)serverGemMahou, null, (INBT)nbtt);
            if (gemMahou != null) {
                gemMahou.setStoredMana(serverGemMahou.getStoredMana());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IGemMahou gemMahou;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Item item = stack.func_77973_b();
        if (item instanceof AttunedGem && Utils.getGemMahou(stack) != null && (gemMahou = Utils.getGemMahou(stack)) != null) {
            String maxMana = "" + ((AttunedGem)item).getMaxMana();
            String storedMana = "" + gemMahou.getStoredMana();
            tooltip.add((ITextComponent)new StringTextComponent(storedMana + " / " + maxMana));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && stack.func_77973_b() instanceof AttunedGem && !player.func_226273_bm_()) {
            this.charge(stack, player);
            AttunedGem.triggerUpdate((ServerPlayerEntity)player, stack);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void charge(ItemStack itemStack, PlayerEntity player) {
        IMahou playerMahou = Utils.getPlayerMahou(player);
        IGemMahou gemMahou = Utils.getGemMahou(itemStack);
        if (gemMahou != null && playerMahou != null) {
            int storedMana = gemMahou.getStoredMana();
            double chargeRate = playerMahou.getChargeRate();
            int playerMaxMana = playerMahou.getMaxMana();
            int manaDifference = (int)Math.ceil((double)playerMaxMana * chargeRate);
            if (storedMana < this.getMaxMana()) {
                manaDifference = Math.min(manaDifference, this.getMaxMana() - storedMana);
                manaDifference = PlayerManaManager.drainMana(player, manaDifference, true, false);
                gemMahou.setStoredMana(storedMana + manaDifference);
            }
            if ((storedMana = gemMahou.getStoredMana()) >= this.getMaxMana()) {
                gemMahou.setStoredMana(this.getMaxMana());
            }
            itemStack.func_77982_d((CompoundNBT)GemMahouProvider.MAHOU.getStorage().writeNBT(GemMahouProvider.MAHOU, (Object)gemMahou, null));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        return stack;
    }

    public static void triggerUpdate(ServerPlayerEntity player, ItemStack stack) {
        player.field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(player.field_71071_by.field_70461_c));
    }
}

