/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.fluids;

import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.ChunkDim;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MurkyWaterBlock
extends FlowingFluidBlock {
    private static boolean pushesEntity;
    protected String name = "murky_water";
    public static HashSet<ChunkDim> murkies;

    public MurkyWaterBlock(Supplier<? extends FlowingFluid> fluid, AbstractBlock.Properties properties) {
        super(fluid, properties);
        this.setRegistryName(this.name);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState state2, boolean v1) {
        if (!world.field_72995_K) {
            IChunkMahou chunkMahou;
            IChunk c = world.func_217349_x(pos);
            if (c instanceof Chunk && (chunkMahou = Utils.getChunkMahou((Chunk)c)) != null && chunkMahou.getLakeBlocks() != null) {
                chunkMahou.getLakeBlocks().remove((Object)pos);
            }
            if (murkies == null) {
                murkies = new HashSet();
            }
            murkies.add(new ChunkDim(c.func_76632_l(), EffectUtil.getDimension(world)));
        }
        super.func_196243_a(state, world, pos, state2, v1);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.field_72995_K) {
            IChunkMahou chunkMahou;
            IChunk c = world.func_217349_x(pos);
            if (c instanceof Chunk && (chunkMahou = Utils.getChunkMahou((Chunk)c)) != null && chunkMahou.getLakeBlocks() != null) {
                chunkMahou.getLakeBlocks().add((Object)pos);
            }
            if (murkies == null) {
                murkies = new HashSet();
            }
            murkies.add(new ChunkDim(c.func_76632_l(), EffectUtil.getDimension(world)));
        }
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    public static void murkyUpdateTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && event.world.func_82737_E() % 4L == 0L) {
            for (ChunkDim p : murkies) {
                ServerWorld world = EffectUtil.getNewDimensionByName((ServerWorld)event.world, p.dim);
                Chunk c = world.func_212866_a_(p.pos.field_77276_a, p.pos.field_77275_b);
                IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                if (chunkMahou == null) continue;
                PacketHandler.sendTrackingBlock(p.pos.func_206849_h(), (World)EffectUtil.getNewDimensionByName((ServerWorld)event.world, p.dim), new ChunkMahouPacket(chunkMahou.getLakeBlocks(), p.pos.field_77276_a, p.pos.field_77275_b));
            }
            murkies.clear();
        }
    }

    static {
        murkies = new HashSet();
    }
}

