/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.FakeExplosion;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.tile.exchange.AlchemicalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class FallenDownBeamEntity
extends Entity {
    PlayerEntity player;
    public static final String entityName = "fallen_down_beam_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(FallenDownBeamEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(FallenDownBeamEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> FIRED = EntityDataManager.func_187226_a(FallenDownBeamEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;

    public FallenDownBeamEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.FALLEN_DOWN_BEAM, worldIn);
        this.field_70158_ak = true;
    }

    public FallenDownBeamEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public FallenDownBeamEntity(World world) {
        super(ModEntities.FALLEN_DOWN_BEAM, world);
        this.field_70158_ak = true;
    }

    public FallenDownBeamEntity(World world, LivingEntity caster) {
        this(world);
        this.setCasterUUID(caster.func_110124_au());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(FIRED, (Object)false);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setFired(compound.func_74767_n(TAG_FIRED));
        if (compound.func_186855_b(TAG_CASTER)) {
            this.setCasterUUID(compound.func_186857_a(TAG_CASTER));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_74757_a(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.func_186854_a(TAG_CASTER, this.getCasterUUID());
        }
    }

    public float getGrowingLife() {
        return 50.0f;
    }

    public double getCurrentRadius() {
        return Math.max(0.0, Math.min((double)MTConfig.FALLEN_DOWN_RADIUS, (double)((float)this.getLife() - this.getGrowingLife()) * 0.12));
    }

    public void func_70071_h_() {
        double radius = this.getCurrentRadius();
        if (!this.field_70170_p.field_72995_K && ServerHandler.tickCounter % 4L == 0L) {
            ServerPlayerEntity caster = null;
            if (this.field_70170_p.func_73046_m() != null) {
                caster = this.field_70170_p.func_73046_m().func_184103_al().func_177451_a(this.getCasterUUID());
            }
            int mana = MTConfig.FALLEN_DOWN_MANA_PER_TICK;
            if (caster == null || !(caster.func_184607_cu().func_77973_b() instanceof FallenDownSpellScroll) && !(caster.func_184607_cu().func_77973_b() instanceof MysticCode)) {
                this.func_70106_y();
            }
            if (caster == null) {
                this.func_70106_y();
                return;
            }
            if (PlayerManaManager.drainMana((PlayerEntity)caster, mana, false, false, true, false) == mana && this.getLife() > 20) {
                AxisAlignedBB aabb = new AxisAlignedBB((double)this.field_233558_ap_.func_177958_n() - radius, 0.0, (double)this.field_233558_ap_.func_177952_p() - radius, (double)this.field_233558_ap_.func_177958_n() + radius, 255.0, (double)this.field_233558_ap_.func_177952_p() + radius);
                List lst = this.field_70170_p.func_175674_a((Entity)this, aabb, a -> a instanceof LivingEntity && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.getCasterUUID(), a));
                float damage = (float)MTConfig.FALLEN_DOWN_BEAM_DAMAGE;
                IMahou mahou = Utils.getPlayerMahou((PlayerEntity)caster);
                if (mahou != null) {
                    damage = (float)((double)damage + (double)mahou.getMaxMana() * MTConfig.FALLEN_DOWN_BEAM_MANA_SCALED_DAMAGE);
                }
                for (Entity e : lst) {
                    float extra = 0.0f;
                    if (e instanceof LivingEntity) {
                        extra = (float)((double)((LivingEntity)e).func_110143_aJ() * MTConfig.FALLEN_DOWN_BEAM_TARGET_HEALTH_PERCENTAGE_DAMAGE);
                    }
                    e.func_70097_a(DamageSource.field_76370_b, damage + extra);
                }
                ArrayList<BlockPos> blocksBurn = new ArrayList<BlockPos>();
                if (radius > 0.0) {
                    for (double i = -radius - 2.0; i < radius + 2.0; i += 1.0) {
                        for (double j = -radius - 2.0; j < radius + 2.0; j += 1.0) {
                            for (int y = 0; y < 256; ++y) {
                                BlockPos pos;
                                BlockState bs;
                                if (!(i * i + j * j < (radius + 1.0) * (radius + 1.0)) || !(bs = this.field_70170_p.func_180495_p(pos = caster.func_233580_cy_().func_177963_a(i, (double)y, j).func_177963_a(0.0, -caster.func_226278_cu_(), 0.0))).func_185904_a().func_76217_h() && this.getBlocksTransform(bs.func_177230_c().getRegistryName()) == null) continue;
                                blocksBurn.add(pos);
                            }
                        }
                    }
                }
                this.tryFakeExplosionFallenDown(blocksBurn, (PlayerEntity)caster, (ServerWorld)this.field_70170_p, "", false, false);
            }
        }
        this.setLife(this.getLife() + 1);
    }

    public void tryFakeExplosionFallenDown(List<BlockPos> affected, PlayerEntity caster, ServerWorld world, String name, boolean drop, boolean fall) {
        if (caster == null && this.player == null) {
            this.player = new SafeFakePlayer(world, name);
        } else if (caster != null) {
            this.player = caster;
        }
        Collections.shuffle(affected);
        FakeExplosion explosion = new FakeExplosion((World)world, (Entity)this.player, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), 10.0f, affected);
        ExplosionEvent.Detonate ee = new ExplosionEvent.Detonate(this.player.field_70170_p, (Explosion)explosion, new ArrayList());
        MinecraftForge.EVENT_BUS.post((Event)ee);
        int limit = 0;
        if (!ee.isCanceled()) {
            for (BlockPos p : ee.getAffectedBlocks()) {
                if (limit >= MTConfig.FALLEN_DOWN_BLOCK_BREAK_PER_TICK) break;
                BlockState bs = this.player.field_70170_p.func_180495_p(p);
                if (!FallenDownBeamEntity.okToBreak(bs, this.player.field_70170_p, p)) continue;
                Block b = this.getBlocksTransform(bs.func_177230_c().getRegistryName());
                if (b != null) {
                    world.func_175656_a(p, b.func_176223_P());
                }
                if (Math.random() < 0.04 && world.func_175623_d(p.func_177984_a())) {
                    world.func_175656_a(p.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
                ++limit;
            }
        }
    }

    public Block getBlocksTransform(ResourceLocation loc) {
        List<? extends String> inblocks = MTConfig.FALLEN_DOWN_BEAM_IN;
        List<? extends String> outblocks = MTConfig.FALLEN_DOWN_BEAM_OUT;
        String m = loc.toString();
        int index = inblocks.indexOf(m);
        Block b = null;
        if (index >= 0 && index < outblocks.size()) {
            b = AlchemicalExchangeMahoujinTileEntity.getBlockFromRegistryName(outblocks.get(index));
        } else {
            index = inblocks.indexOf(loc.func_110624_b());
            if (index >= 0 && index < outblocks.size()) {
                b = AlchemicalExchangeMahoujinTileEntity.getBlockFromRegistryName(outblocks.get(index));
            }
        }
        if (b != null && b.getRegistryName() != null && b.getRegistryName().equals((Object)loc)) {
            return null;
        }
        return b;
    }

    public static boolean okToBreak(BlockState bs, World w, BlockPos p) {
        return bs.func_177230_c() != Blocks.field_150357_h && !bs.func_177230_c().isAir(bs, (IBlockReader)w, p) && w.func_175625_s(p) == null;
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRED);
    }

    public void setFired(boolean f) {
        this.field_70180_af.func_187227_b(FIRED, (Object)f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

