/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.clarent.Clarent;

public class GateWeaponProjectileEntity
extends ArrowEntity {
    public static final String entityName = "gate_weapon_projectile_entity";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Float> PROGRESS = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R2 = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G2 = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B2 = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private float progress = 0.0f;
    public float lastProgress = 0.0f;

    public GateWeaponProjectileEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.GATE_WEAPON_PROJECTILE, worldIn);
        this.field_70158_ak = true;
    }

    public GateWeaponProjectileEntity(World worldIn) {
        super(ModEntities.GATE_WEAPON_PROJECTILE, worldIn);
        this.field_70158_ak = true;
        this.setStack(new ItemStack((IItemProvider)Items.field_151040_l));
    }

    public GateWeaponProjectileEntity(World worldIn, double x, double y, double z, ItemStack stack, Entity e, float speed) {
        this(worldIn);
        this.field_70158_ak = true;
        this.func_70107_b(x, y, z);
        this.setStack(stack);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
        this.func_212361_a(e);
        this.setSpeed(speed);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_R2, (Object)Float.valueOf(r2));
        this.field_70180_af.func_187227_b(COLOR_G2, (Object)Float.valueOf(g2));
        this.field_70180_af.func_187227_b(COLOR_B2, (Object)Float.valueOf(b2));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getTColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_R2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G2)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B2)).floatValue()};
    }

    public GateWeaponProjectileEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)new ItemStack((IItemProvider)Items.field_151040_l));
        this.func_184212_Q().func_187214_a(PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf((float)MTConfig.TREASURY_PROJECTION_SPEED));
        super.func_70088_a();
    }

    public void func_213281_b(CompoundNBT nbt) {
        if (this.getStack() != null) {
            nbt.func_218657_a("stackNBT", (INBT)this.getStack().serializeNBT());
        }
        nbt.func_74776_a("progress", this.progress);
        float[] colors = this.getTColor();
        nbt.func_74776_a(TAG_COLOR_R, colors[0]);
        nbt.func_74776_a(TAG_COLOR_G, colors[1]);
        nbt.func_74776_a(TAG_COLOR_B, colors[2]);
        nbt.func_74776_a(TAG_COLOR_A, colors[3]);
        nbt.func_74776_a(TAG_COLOR_R2, colors[4]);
        nbt.func_74776_a(TAG_COLOR_G2, colors[5]);
        nbt.func_74776_a(TAG_COLOR_B2, colors[6]);
        super.func_213281_b(nbt);
    }

    public void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("stackNBT")) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("stackNBT")));
            stack.func_190920_e(1);
            this.setStack(stack);
        }
        this.progress = nbt.func_74760_g("progress");
        this.setColor(nbt.func_74760_g(TAG_COLOR_R), nbt.func_74760_g(TAG_COLOR_G), nbt.func_74760_g(TAG_COLOR_B), nbt.func_74760_g(TAG_COLOR_A), nbt.func_74760_g(TAG_COLOR_R2), nbt.func_74760_g(TAG_COLOR_G2), nbt.func_74760_g(TAG_COLOR_B2));
        super.func_70037_a(nbt);
    }

    protected ItemStack func_184550_j() {
        return this.getStack();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float v) {
        this.progress = v;
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        double d = this.func_213322_ci().func_72433_c();
        double damage = MathHelper.func_76143_f((double)d);
        Entity entity = result.func_216348_a();
        if (this.field_70170_p instanceof ServerWorld) {
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerWorld)this.field_70170_p, "faker");
            fake_player.func_184611_a(Hand.MAIN_HAND, this.func_184550_j());
            fake_player.func_230245_c_(true);
            fake_player.func_233645_dx_().func_233793_b_(this.func_184550_j().func_111283_C(EquipmentSlotType.MAINHAND));
            fake_player.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.getStack().func_77973_b() instanceof Clarent && this.func_234616_v_() instanceof PlayerEntity) {
                    int mana = ClarentEffect.getManaCostClarent(this.getStack(), (PlayerEntity)this.func_234616_v_());
                    PlayerManaManager.donateManaToFakePlayer(fake_player, (PlayerEntity)this.func_234616_v_(), mana);
                }
                fake_player.field_184617_aD = 1000;
                fake_player.func_71059_n(entity);
                this.func_184548_a(livingEntity);
                Entity shooter = null;
                if (this.func_234616_v_() != null && this.field_70170_p != null && (shooter = this.func_234616_v_()) != null && entity != shooter && livingEntity instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
            }
        }
        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    public void func_70071_h_() {
        this.func_225516_i_();
        this.func_225516_i_();
        this.lastProgress = this.getProgress();
        float progressCap = this.getProgressCap();
        if (this.getProgress() > progressCap) {
            super.func_70071_h_();
            if (this.field_70254_i && MTConfig.TREASURY_PROJECTION_DESPAWN_AFTER_LAND) {
                this.func_70106_y();
            }
        } else {
            if (this.field_70254_i) {
                this.setProgress(this.getProgressCap() + 1.0f);
            }
            float speed = this.getProgressSpeed();
            this.setProgress(this.getProgress() + progressCap / speed);
            Vector3d z = this.func_213322_ci();
            z = z.func_72432_b().func_186678_a((double)(progressCap / speed));
            z = z.func_178787_e(this.func_213303_ch());
            this.func_70107_b(z.field_72450_a, z.field_72448_b, z.field_72449_c);
        }
    }

    public void func_70100_b_(PlayerEntity player) {
    }

    public float getSpeed() {
        return ((Float)this.func_184212_Q().func_187225_a(SPEED)).floatValue();
    }

    public void setSpeed(float s) {
        this.func_184212_Q().func_187227_b(SPEED, (Object)Float.valueOf(s));
    }

    public ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setProgress() {
        this.setProgress(this.progress);
    }

    public float getProgressCap() {
        return 4.0f;
    }

    public float getProgressSpeed() {
        return (float)Math.max(MTConfig.TREASURY_PROJECTION_SPEED_MIN, (double)this.getSpeed());
    }
}

