/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class ScryingEntityPacket {
    public double posX;
    public double posY;
    public double posZ;
    public CompoundNBT entityTag;

    public ScryingEntityPacket() {
    }

    public ScryingEntityPacket(double posX, double posY, double posZ, CompoundNBT tag) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.entityTag = tag;
    }

    public void fromBytes(PacketBuffer buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.entityTag = buf.readBoolean() ? buf.func_244273_m() : null;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        if (this.entityTag == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_150786_a(this.entityTag);
        }
    }

    public static void encode(ScryingEntityPacket msg, PacketBuffer buf) {
        msg.toBytes(buf);
    }

    public static ScryingEntityPacket decode(PacketBuffer buf) {
        ScryingEntityPacket msg = new ScryingEntityPacket();
        msg.fromBytes(buf);
        return msg;
    }

    public static void handle(ScryingEntityPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.scryingHandler(message);
        context.get().setPacketHandled(true);
    }
}

