/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.item.replica.Replica;

public class ReplicaSwitchPacket {
    int slot;

    public ReplicaSwitchPacket() {
    }

    public ReplicaSwitchPacket(int s) {
        this.slot = s;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
    }

    public static void encode(ReplicaSwitchPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ReplicaSwitchPacket decode(PacketBuffer buf) {
        ReplicaSwitchPacket msg = new ReplicaSwitchPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(ReplicaSwitchPacket message, Supplier<NetworkEvent.Context> context) {
        ReplicaSwitchPacket.handleReplicaSwitch(message, (PlayerEntity)context.get().getSender());
        context.get().setPacketHandled(true);
    }

    public static void handleReplicaSwitch(ReplicaSwitchPacket message, PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof Replica) {
            if (message.slot == 6) {
                Replica.clearDamageTypes(stack);
            } else {
                Replica.setSelectedSlot(stack, message.slot);
            }
        }
    }
}

