/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;

public class MentalDisplacementUpdatePacket {
    public int entityId;
    public double x;
    public double y;
    public double z;
    public double vx;
    public double vy;
    public double vz;
    public double yaw;
    public double pitch;

    public MentalDisplacementUpdatePacket() {
    }

    public MentalDisplacementUpdatePacket(Entity e, double x, double y, double z, double vx, double vy, double vz, double yaw, double pitch) {
        this.entityId = e.func_145782_y();
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.vx = buf.readDouble();
        this.vy = buf.readDouble();
        this.vz = buf.readDouble();
        this.yaw = buf.readDouble();
        this.pitch = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.vx);
        buf.writeDouble(this.vy);
        buf.writeDouble(this.vz);
        buf.writeDouble(this.yaw);
        buf.writeDouble(this.pitch);
    }

    public static void encode(MentalDisplacementUpdatePacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static MentalDisplacementUpdatePacket decode(PacketBuffer buf) {
        MentalDisplacementUpdatePacket msg = new MentalDisplacementUpdatePacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final MentalDisplacementUpdatePacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                World world = player.field_70170_p;
                Entity e = world.func_73045_a(message.entityId);
                if (e instanceof MentalDisplacementEntity) {
                    MentalDisplacementUpdatePacket.updatePosition((MentalDisplacementEntity)e, message);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void updatePosition(MentalDisplacementEntity entity, MentalDisplacementUpdatePacket packet) {
        entity.updatePacket(packet);
    }
}

