/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityStickPacket {
    boolean stick;

    public AuthorityStickPacket() {
    }

    public AuthorityStickPacket(boolean stick) {
        this.stick = stick;
    }

    public void fromBytes(ByteBuf buf) {
        this.stick = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.stick);
    }

    public static void encode(AuthorityStickPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static AuthorityStickPacket decode(PacketBuffer buf) {
        AuthorityStickPacket msg = new AuthorityStickPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final AuthorityStickPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                AuthorityStickPacket.authorityStick(message, ((NetworkEvent.Context)context.get()).getSender());
            }
        });
    }

    public static void authorityStick(AuthorityStickPacket message, ServerPlayerEntity player) {
        if (player != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY)) {
            if (message.stick) {
                EffectUtil.buff((LivingEntity)player, ModEffects.WALL_STICK, false, 2000);
            } else {
                EffectUtil.debuff((LivingEntity)player, ModEffects.WALL_STICK);
            }
        }
    }
}

