/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.WallStickPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityJumpPacket {
    double lookX;
    double lookY;
    double lookZ;
    long held;

    public AuthorityJumpPacket() {
    }

    public AuthorityJumpPacket(double x, double y, double z, long h) {
        this.lookX = x;
        this.lookY = y;
        this.lookZ = z;
        this.held = h;
    }

    public void fromBytes(ByteBuf buf) {
        this.lookX = buf.readDouble();
        this.lookY = buf.readDouble();
        this.lookZ = buf.readDouble();
        this.held = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.lookX);
        buf.writeDouble(this.lookY);
        buf.writeDouble(this.lookZ);
        buf.writeLong(this.held);
    }

    public static void encode(AuthorityJumpPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static AuthorityJumpPacket decode(PacketBuffer buf) {
        AuthorityJumpPacket msg = new AuthorityJumpPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final AuthorityJumpPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                AuthorityJumpPacket.authorityJump(message, ((NetworkEvent.Context)context.get()).getSender());
            }
        });
    }

    public static void authorityJump(AuthorityJumpPacket packet, ServerPlayerEntity player) {
        if (player != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY) && WallStickPotion.onWallOrGround((LivingEntity)player)) {
            AuthorityJumpPacket.boop((Entity)player, Math.min((float)packet.held / 4.0f, 5.0f), -packet.lookX, -packet.lookY, -packet.lookZ);
            EffectUtil.buff((LivingEntity)player, ModEffects.AUTHORITY_JUMP, false, 900, false);
        }
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        entity.field_70133_I = true;
        entity.func_213317_d(new Vector3d(motionX -= x / (double)f * (double)strength, motionY -= y / (double)f * (double)strength, motionZ -= z / (double)f * (double)strength));
    }
}

