/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret;

import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownBeamEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownEntity;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.util.Utils;

public class FallenDownSpellScroll
extends SpellScroll {
    public static HashMap<UUID, FallenDownUserStorage> storages = new HashMap();
    private String MODE_TAG = "MAHOUTSUKAI_BEAM_MODE_ON";

    public FallenDownSpellScroll() {
        super("fallen_down");
    }

    @Override
    public int getInitialManaCost() {
        return 0;
    }

    public void setBeamMode(ItemStack scroll, int mode) {
        IScrollMahou mahou = Utils.getScrollMahou(scroll);
        if (mahou != null) {
            CompoundNBT nbt = mahou.getSpellStorage();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_74768_a(this.MODE_TAG, mode);
            mahou.setSpellStorage(nbt);
        }
    }

    public int getBeamMode(ItemStack scroll) {
        CompoundNBT nbt;
        IScrollMahou mahou = Utils.getScrollMahou(scroll);
        if (mahou != null && (nbt = mahou.getSpellStorage()) != null && nbt.func_74764_b(this.MODE_TAG)) {
            return nbt.func_74762_e(this.MODE_TAG);
        }
        return 0;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_226273_bm_()) {
            if (!world.field_72995_K) {
                this.setBeamMode(stack, (this.getBeamMode(stack) + 1) % 2);
                int mode = this.getBeamMode(stack);
                TranslationTextComponent tt = mode == 0 ? new TranslationTextComponent("mahoutsukai.fallendown.burial") : new TranslationTextComponent("mahoutsukai.fallendown.beam");
                player.func_146105_b((ITextComponent)tt, true);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!player.field_70170_p.field_72995_K) {
            if (storages.containsKey(player.func_110124_au())) {
                FallenDownUserStorage storage = storages.get(player.func_110124_au());
            } else if (this.getBeamMode(stack) == 0) {
                FallenDownUserStorage storage = new FallenDownUserStorage();
                storages.put(player.func_110124_au(), storage);
                storage.fd = new FallenDownEntity(player.field_70170_p, player);
                storage.fd.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                player.field_70170_p.func_217376_c((Entity)storage.fd);
            } else {
                FallenDownUserStorage storage = new FallenDownUserStorage();
                storages.put(player.func_110124_au(), storage);
                storage.beam = new FallenDownBeamEntity(player.field_70170_p, player);
                storage.beam.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                player.field_70170_p.func_217376_c((Entity)storage.beam);
            }
        }
    }

    @Override
    public void useAction(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.field_72995_K) {
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (entityLiving instanceof PlayerEntity && Utils.getPlayerMahou((PlayerEntity)entityLiving) != null) {
                PlayerEntity user = (PlayerEntity)entityLiving;
                if (scrollMahou != null && (user.func_110124_au().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(FaeEssence.faeID) || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.func_184812_l_())) {
                    if (this.shouldConsume(user, scrollMahou, consume)) {
                        stack.func_190918_g(1);
                    }
                    stack.func_77982_d((CompoundNBT)ScrollMahouProvider.MAHOU.getStorage().writeNBT(ScrollMahouProvider.MAHOU, (Object)scrollMahou, null));
                }
            }
        }
    }

    @Override
    public boolean doSpell(PlayerEntity user, IScrollMahou scrollMahou) {
        if (storages.containsKey(user.func_110124_au())) {
            FallenDownUserStorage storage = storages.get(user.func_110124_au());
            if (storage.fd != null) {
                storage.fd.func_70106_y();
            }
            if (storage.beam != null) {
                storage.beam.func_70106_y();
            }
            storages.remove(user.func_110124_au());
            return true;
        }
        return false;
    }

    public class FallenDownUserStorage {
        FallenDownEntity fd;
        FallenDownBeamEntity beam;
    }
}

