/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.WeaponProjectile;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.rulebreaker.RuleBreaker;
import stepsword.mahoutsukai.item.spells.projection.ProjectionSpellScroll;
import stepsword.mahoutsukai.render.item.WeaponProjectileBowRenderer;
import stepsword.mahoutsukai.util.Utils;

public class WeaponProjectileBow
extends BowItem {
    String name = "weapon_projectile_bow";
    public static String AMMO_STACK = "mahoutsukai_ammo_stack";
    private String MODE_TAG = "MAHOUTSUKAI_WPBOW_MODE";

    public WeaponProjectileBow() {
        super(new Item.Properties().setISTER(() -> WeaponProjectileBowRenderer::new).func_200917_a(1).func_200918_c(MTConfig.WEAPON_SHOOTER_DURABILITY).func_200916_a(ModItems.MAHOUTSUKAI_CREATIVE_TAB));
    }

    public WeaponProjectileBow setup() {
        this.setRegistryName(this.name);
        return this;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.WEAPON_SHOOTER_DURABILITY;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean flag2;
        ItemStack stack = player.func_184586_b(hand);
        ItemStack s = new ItemStack((IItemProvider)Items.field_190931_a);
        ItemStack weapon = new ItemStack((IItemProvider)Items.field_190931_a);
        if (this.getMode(stack) == 1) {
            s = this.findAmmo(player, stack, true);
            if (s == null || s.func_190926_b() || s.func_77973_b() == Items.field_151032_g) {
                CompoundNBT nbt;
                IScrollMahou mahou;
                ItemStack scroll = this.findProjection(player, stack);
                if (scroll.func_77973_b() instanceof ProjectionSpellScroll) {
                    ((ProjectionSpellScroll)scroll.func_77973_b()).useAction(scroll, world, (LivingEntity)player, true);
                }
                s = this.findAmmo(player, stack, true);
                if (world.field_72995_K && (s == null || s.func_190926_b() || s.func_77973_b() == Items.field_151032_g) && scroll.func_77973_b() instanceof ProjectionSpellScroll && (mahou = Utils.getScrollMahou(scroll)) != null && (nbt = mahou.getSpellStorage()) != null && nbt.func_74764_b("MAHOUTSUKAI_MEMORIZED_WEAPON")) {
                    s = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("MAHOUTSUKAI_MEMORIZED_WEAPON")).func_77946_l();
                }
            }
            weapon = s;
        } else {
            weapon = s = this.findAmmo(player, stack, false);
        }
        boolean flag = s != null && !s.func_190926_b() && s.func_77973_b() != Items.field_151032_g;
        boolean bl = flag2 = weapon != null && !weapon.func_190926_b() && weapon.func_77973_b() != Items.field_151032_g;
        if ((!flag && !world.field_72995_K || !flag2 && world.field_72995_K) && !player.func_226273_bm_()) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!player.func_226273_bm_()) {
            this.setAmmoStack(stack, weapon);
            player.func_184598_c(hand);
            return ActionResult.func_226248_a_((Object)stack);
        }
        this.setMode(stack, (this.getMode(stack) + 1) % 2);
        int mode = this.getMode(stack);
        TranslationTextComponent tt = mode == 0 ? new TranslationTextComponent("mahoutsukai.weaponprojectiles.normal") : new TranslationTextComponent("mahoutsukai.weaponprojectiles.projections");
        player.func_146105_b((ITextComponent)tt, true);
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ItemStack findAmmo(PlayerEntity player, ItemStack shootable, boolean projectedOnly) {
        ItemStack itemstack1;
        int i;
        if (!(shootable.func_77973_b() instanceof WeaponProjectileBow)) {
            return ItemStack.field_190927_a;
        }
        Predicate<ItemStack> prepredicate = ((WeaponProjectileBow)shootable.func_77973_b()).getPreInventoryAmmoPredicate();
        Predicate<ItemStack> predicate = ((WeaponProjectileBow)shootable.func_77973_b()).func_220006_d();
        ItemStack itemstack = WeaponProjectileBow.func_220005_a((LivingEntity)player, (Predicate)predicate);
        if (!itemstack.func_190926_b()) {
            return itemstack;
        }
        prepredicate = ((WeaponProjectileBow)shootable.func_77973_b()).getPreInventoryAmmoPredicate();
        predicate = ((WeaponProjectileBow)shootable.func_77973_b()).func_220004_b();
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack1 = player.field_71071_by.func_70301_a(i);
            if (!prepredicate.test(itemstack1)) continue;
            return itemstack1;
        }
        if (!projectedOnly) {
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                itemstack1 = player.field_71071_by.func_70301_a(i);
                if (!predicate.test(itemstack1)) continue;
                return itemstack1;
            }
        }
        return player.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)Items.field_151032_g) : ItemStack.field_190927_a;
    }

    public ItemStack findProjection(PlayerEntity player, ItemStack shootable) {
        if (!(shootable.func_77973_b() instanceof WeaponProjectileBow)) {
            return ItemStack.field_190927_a;
        }
        Predicate<ItemStack> predicate = a -> a.func_77973_b() instanceof ProjectionSpellScroll;
        ItemStack itemstack = WeaponProjectileBow.func_220005_a((LivingEntity)player, predicate);
        if (!itemstack.func_190926_b()) {
            return itemstack;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack1 = player.field_71071_by.func_70301_a(i);
            if (!predicate.test(itemstack1)) continue;
            return itemstack1;
        }
        return player.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)Items.field_151032_g) : ItemStack.field_190927_a;
    }

    public void deleteAmmoStack(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b(AMMO_STACK)) {
            nbt.func_218657_a(AMMO_STACK, (INBT)new CompoundNBT());
            stack.func_77982_d(nbt);
        }
    }

    public void setAmmoStack(ItemStack bow, ItemStack projectile) {
        CompoundNBT nbt = bow.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_218657_a(AMMO_STACK, (INBT)projectile.func_77946_l().serializeNBT());
        bow.func_77982_d(nbt);
    }

    public ItemStack getAmmoStack(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b(AMMO_STACK)) {
            return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a(AMMO_STACK))).func_77946_l();
        }
        return null;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public Predicate<ItemStack> getPreInventoryAmmoPredicate() {
        return s -> this.isArrow((ItemStack)s) && ProjectionSpellEffect.getProjected(s);
    }

    public Predicate<ItemStack> func_220004_b() {
        return s -> this.isArrow((ItemStack)s);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity shooter, int useTicks) {
        if (shooter instanceof PlayerEntity) {
            float f;
            PlayerEntity player = (PlayerEntity)shooter;
            ItemStack projectile = new ItemStack((IItemProvider)Items.field_190931_a);
            projectile = this.getMode(stack) == 1 ? this.findAmmo(player, stack, true) : this.findAmmo(player, stack, false);
            int i = this.func_77626_a(stack) - useTicks;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (PlayerEntity)player, (int)i, (projectile != ItemStack.field_190927_a ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!player.field_70170_p.field_72995_K) {
                List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.WEAPON_PROJECTILE);
                Utils.color(stack, settings.get(0).intValue(), settings.get(1).intValue(), settings.get(2).intValue(), settings.get(3).intValue(), settings.get(4).intValue(), settings.get(5).intValue());
            }
            if (projectile != ItemStack.field_190927_a && (double)(f = WeaponProjectileBow.func_185059_b((int)i)) >= 0.1) {
                if (!world.field_72995_K) {
                    if (!this.isArrow(projectile)) {
                        return;
                    }
                    WeaponProjectileEntity projectileEntity = new WeaponProjectileEntity(world, shooter, projectile.func_77946_l());
                    projectileEntity.shoot((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, (float)((double)f * MTConfig.WEAPON_SHOOTER_PROJECTILE_SPEED), 1.0f);
                    projectileEntity.func_212361_a((Entity)shooter);
                    world.func_217376_c((Entity)projectileEntity);
                    stack.func_222118_a(1, shooter, a -> {});
                }
                if (!player.func_184812_l_()) {
                    projectile.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(projectile);
                    }
                }
                world.func_184133_a(null, shooter.func_233580_cy_(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (shooter.func_70681_au().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            }
        }
    }

    protected boolean isArrow(ItemStack stack) {
        Item tmpi = stack.func_77973_b();
        return (tmpi instanceof SwordItem || tmpi instanceof ToolItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof HoeItem || tmpi instanceof TridentItem) && !(tmpi instanceof RuleBreaker);
    }

    public void setMode(ItemStack gauntlet, int mode) {
        CompoundNBT nbt = gauntlet.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a(this.MODE_TAG, mode);
        gauntlet.func_77982_d(nbt);
    }

    public int getMode(ItemStack gauntlet) {
        CompoundNBT nbt = gauntlet.func_77978_p();
        if (nbt != null && nbt.func_74764_b(this.MODE_TAG)) {
            return nbt.func_74762_e(this.MODE_TAG);
        }
        return 0;
    }
}

