/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.kodoku;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.kodoku.IKodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahouProvider;
import stepsword.mahoutsukai.entity.kodoku.KodokuEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class KodokuItem
extends ItemBase {
    public KodokuItem() {
        super("kodoku");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new KodokuMahouProvider();
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            IKodokuMahou mahou = Utils.getKodokuMahou(stack);
            return (CompoundNBT)KodokuMahouProvider.MAHOU.getStorage().writeNBT(KodokuMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        if (nbtt != null) {
            IKodokuMahou kodokuMahou = Utils.getKodokuMahou(stack);
            KodokuMahou serverKodokuMahou = new KodokuMahou();
            KodokuMahouProvider.MAHOU.getStorage().readNBT(KodokuMahouProvider.MAHOU, (Object)serverKodokuMahou, null, (INBT)nbtt);
            if (kodokuMahou != null) {
                kodokuMahou.setKodoku(serverKodokuMahou.getKodoku());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IKodokuMahou kodokuMahou;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Item item = stack.func_77973_b();
        if (item instanceof KodokuItem && (kodokuMahou = Utils.getKodokuMahou(stack)) != null) {
            String kodoku = "" + kodokuMahou.getKodoku();
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("mahoutsukai.kodoku").getString() + ": " + kodoku));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        Direction facing = context.func_196000_l();
        if (!worldIn.field_72995_K) {
            KodokuItem.setKodoku(player.func_184614_ca(), KodokuItem.getKodoku(player.func_184614_ca()));
            KodokuEntity entity = new KodokuEntity(worldIn);
            Vector3d place = EffectUtil.fromBlockPos(pos.func_177972_a(facing));
            entity.func_70080_a(place.field_72450_a + 0.5 + Math.random() * 0.3, place.field_72448_b, place.field_72449_c + 0.5 + Math.random() * 0.3, (float)(Math.random() * 360.0), 0.0f);
            entity.kodoku = KodokuItem.getKodoku(player.func_184586_b(hand));
            worldIn.func_217376_c((Entity)entity);
            player.func_184586_b(hand).func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (!target.field_70170_p.field_72995_K) {
            int kodoku = KodokuItem.getKodoku(playerIn.func_184586_b(hand));
            boolean hasworm = false;
            for (int i = 0; i < target.func_184188_bt().size(); ++i) {
                if (!(target.func_184188_bt().get(i) instanceof KodokuEntity)) continue;
                hasworm = true;
            }
            if (kodoku <= 0 && !(target instanceof KodokuEntity) && !hasworm) {
                KodokuEntity entity = new KodokuEntity(target.field_70170_p);
                entity.func_70080_a(target.func_226277_ct_() - (double)(target.func_213305_a(null).field_220315_a / 2.0f), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A + 90.0f);
                target.field_70170_p.func_217376_c((Entity)entity);
                entity.func_184205_a((Entity)target, true);
                playerIn.func_184586_b(hand).func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static int getKodoku(ItemStack stack) {
        IKodokuMahou mahou = Utils.getKodokuMahou(stack);
        if (mahou != null) {
            return mahou.getKodoku();
        }
        return 0;
    }

    public static void setKodoku(ItemStack stack, int k) {
        IKodokuMahou mahou = Utils.getKodokuMahou(stack);
        if (mahou != null) {
            mahou.setKodoku(k);
        }
        stack.func_77982_d((CompoundNBT)KodokuMahouProvider.MAHOU.getStorage().writeNBT(KodokuMahouProvider.MAHOU, (Object)mahou, null));
    }

    public boolean func_77651_p() {
        return true;
    }
}

