/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;

public class SmiteEntity
extends Entity {
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    public static final AxisAlignedBB bb = new AxisAlignedBB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final DataParameter<Float> BEAM_SIZE = EntityDataManager.func_187226_a(SmiteEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(SmiteEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(SmiteEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(SmiteEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(SmiteEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DISTANCE = EntityDataManager.func_187226_a(SmiteEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BEAM_LENGTH = EntityDataManager.func_187226_a(SmiteEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public Entity target;
    public float damage;
    public float prev_beam_len;
    public float prev_beam_size;
    public float maxlen = 250.0f;
    public int m;
    public static final String entityName = "smite_entity";

    public SmiteEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public SmiteEntity(World world) {
        super(ModEntities.SMITE, world);
        this.field_70158_ak = true;
    }

    public SmiteEntity(World world, LivingEntity target, float r, float g, float b, float a, float size, float damage) {
        this(world);
        this.setColor(r, g, b, a);
        this.sizer(size);
        this.target = target;
        this.damage = damage;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DISTANCE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.target == null) {
                this.func_70106_y();
                return;
            }
            this.func_70107_b(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
            if ((double)this.getBeamSize() < (double)this.target.func_213311_cf() * 1.5) {
                this.setBeamSize(this.getBeamSize() + 0.1f);
            } else if (this.getBeamLength() < this.maxlen) {
                this.setBeamLength(this.getBeamLength() + 10.0f);
                if (this.getBeamLength() == this.maxlen - 10.0f) {
                    this.field_70170_p.func_184133_a(null, new BlockPos(this.func_213303_ch()), ModSounds.SMITE, SoundCategory.NEUTRAL, (float)MTConfig.SMITE_VOLUME, 1.0f);
                }
            } else {
                ++this.m;
                if (this.m > 5) {
                    EffectUtil.magicAttack((LivingEntity)this.target, this.damage, null);
                    this.func_70106_y();
                }
            }
        } else {
            float[] rgb = this.getColor();
            for (double i = (double)this.prev_beam_len; i < (double)this.getBeamLength(); i += 1.0) {
                MahouTsukaiMod.proxy.smiteParticles(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.maxlen - i, this.func_226281_cx_(), this.field_70146_Z, false, this.getBeamSize(), rgb[0], rgb[1], rgb[2]);
            }
            if (this.getBeamLength() == this.maxlen - 10.0f) {
                MahouTsukaiMod.proxy.smiteParticles(this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), this.field_70146_Z, true, this.getBeamSize(), rgb[0], rgb[1], rgb[2]);
            }
        }
        this.prev_beam_len = this.getBeamLength();
        this.prev_beam_size = this.getBeamSize();
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void func_145775_I() {
    }

    @Nullable
    public AxisAlignedBB func_174813_aQ() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setBeamSize(s);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setBeamSize(compound.func_74760_g(TAG_BEAM_SIZE));
        this.setBeamLength(compound.func_74760_g(TAG_BEAM_LENGTH));
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A));
        this.setDistance(compound.func_74760_g(TAG_DISTANCE));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_BEAM_SIZE, this.getBeamSize());
        compound.func_74776_a(TAG_BEAM_LENGTH, this.getBeamLength());
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
        compound.func_74776_a(TAG_DISTANCE, this.getDistance());
    }

    public AxisAlignedBB func_184177_bl() {
        return bb;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getBeamSize() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float s) {
        this.field_70180_af.func_187227_b(BEAM_SIZE, (Object)Float.valueOf(s));
    }

    public float getBeamLength() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float s) {
        this.field_70180_af.func_187227_b(BEAM_LENGTH, (Object)Float.valueOf(s));
    }

    public float getDistance() {
        return ((Float)this.field_70180_af.func_187225_a(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.field_70180_af.func_187227_b(DISTANCE, (Object)Float.valueOf(d));
    }
}

